---
name: Severity Analysis
description: Analyzes HTTP requests for security severity
model: gpt-4o
output: json
---

Analyze this HTTP request for security severity. Respond with ONLY valid JSON, no markdown.

## Request Context

- **Method**: {{method}}
- **Host**: {{hostname}}
- **Path**: {{pathname}}
- **Status**: {{status}} {{statusText}}
- **Headers**:
```json
{{headers}}
```
{{#if bodyPreview}}
- **Body Preview**: {{bodyPreview}}{{#if bodyTruncated}}... [truncated]{{/if}}
{{/if}}

## Assessment Criteria

Assess security severity based on:

1. **Authentication/Authorization Endpoints** - login, oauth, token, session management
2. **Sensitive Data Exposure** - passwords, tokens, PII in parameters
3. **Admin/Privileged Paths** - /admin, /internal, /debug endpoints
4. **Information Leakage** - error responses with stack traces, internal errors
5. **File Operations** - upload/download endpoints
6. **Mutation Operations** - POST/PUT/DELETE to sensitive resources
7. **Injection Vectors** - id, query, search, filter parameters

## Response Format

Respond with this exact JSON structure:

```json
{
  "severity": "critical|high|medium|low|info",
  "reason": "Brief explanation (max 100 chars)"
}
```

## Severity Guide

| Level | Description | Examples |
|-------|-------------|----------|
| **critical** | Auth bypass, credential exposure, admin access | Login endpoints, token generation, admin panels |
| **high** | Sensitive data handling, privileged operations | User PII, payment data, role changes |
| **medium** | User data modification, interesting parameters | Profile updates, settings changes |
| **low** | Standard authenticated operations | Regular API calls, data retrieval |
| **info** | Static resources, public endpoints | Images, CSS, public APIs |
