---
name: HTTP Vulnerability Analysis
description: Analyzes HTTP request/response pairs for security vulnerabilities
model: gpt-4o
output: markdown
---

Analyze this HTTP request and response for security vulnerabilities. Provide a comprehensive security assessment.

## HTTP Request

```http
{{requestRaw}}
```

## HTTP Response

```http
{{responseRaw}}
```

## Analysis Instructions

Perform a thorough security analysis looking for:

### 1. Input Validation Issues
- SQL Injection vectors (parameters, headers, body)
- NoSQL Injection possibilities
- Command Injection risks
- LDAP/XPath Injection vectors
- Template Injection (SSTI)

### 2. Cross-Site Scripting (XSS)
- Reflected XSS in response
- DOM-based XSS indicators
- Stored XSS potential

### 3. Authentication & Session Issues
- Weak session tokens
- Missing or weak authentication headers
- JWT vulnerabilities (algorithm confusion, weak signing)
- Credential exposure in request/response

### 4. Authorization Flaws
- IDOR (Insecure Direct Object Reference) indicators
- Missing access control checks
- Privilege escalation vectors
- Parameter tampering opportunities

### 5. Information Disclosure
- Sensitive data in URLs or headers
- Verbose error messages
- Server/framework fingerprinting
- Internal paths or IP addresses exposed

### 6. Security Headers Analysis
- Missing Content-Security-Policy
- Missing X-Frame-Options
- Missing X-Content-Type-Options
- CORS misconfigurations
- Cookie security flags (HttpOnly, Secure, SameSite)

### 7. Business Logic Issues
- Rate limiting absence
- Mass assignment vulnerabilities
- Race condition potential

## Response Format

Structure your response as:

### Summary
Brief overview of the request's security posture.

### Findings
For each finding:
- **Severity**: Critical / High / Medium / Low / Info
- **Type**: Category of vulnerability
- **Location**: Where in request/response the issue was found
- **Evidence**: Specific data supporting the finding
- **Impact**: What an attacker could achieve
- **Recommendation**: How to remediate

### Test Payloads
If applicable, suggest specific payloads to confirm vulnerabilities:
- Parameter name and injection point
- Exact payload to test
- Expected response if vulnerable

### Remediation Priority
Rank findings by risk and provide a prioritized remediation plan.

## Editor Inline Notices (Required)

After you identify findings, **publish them back into the user's active HTTP editor** using the `blackswan_addInlineNotices` tool.

Rules:
- Always include a **bottom-of-request summary** (the tool will place it at the bottom of the current request in the editor).
- For each finding, include:
  - `title`
  - `severity` (critical/high/medium/low/info)
  - `type` (e.g., SQLi, XSS, SSRF) if applicable
  - `evidence` (short excerpt)
  - `recommendation`
  - `requestLine` (1-based line number **relative to the HTTP Request block above**) if you can pinpoint it; otherwise omit.
- If you find **no** vulnerabilities, call the tool with `findings: []` to clear any previous notices.
