/*---------------------------------------------------------------------------------------------
 *  Copyright (c) BlackSwan. All rights reserved.
 *  Licensed under the MIT License.
 *--------------------------------------------------------------------------------------------*/

const tsParser = require('@typescript-eslint/parser');
const tsPlugin = require('@typescript-eslint/eslint-plugin');

/** @type {import('eslint').Linter.FlatConfig[]} */
module.exports = [
	{
		ignores: [
			'out/**',
			'dist/**',
			'**/*.d.ts'
		]
	},
	{
		files: [
			'src/**/*.ts',
			'src/**/*.tsx'
		],
		languageOptions: {
			parser: tsParser,
			parserOptions: {
				ecmaVersion: 6,
				sourceType: 'module'
			}
		},
		plugins: {
			'@typescript-eslint': tsPlugin
		},
		rules: {
			'@typescript-eslint/naming-convention': 'warn',
			'@typescript-eslint/semi': 'warn',
			'curly': 'warn',
			'eqeqeq': 'warn',
			'no-throw-literal': 'warn',
			'semi': 'off'
		}
	}
];

