/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/auth/accountStatusBar.ts":
/*!**************************************!*\
  !*** ./src/auth/accountStatusBar.ts ***!
  \**************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) BlackSwan. All rights reserved.
 *  Licensed under the MIT License.
 *--------------------------------------------------------------------------------------------*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AccountStatusBarManager = void 0;
const vscode = __importStar(__webpack_require__(/*! vscode */ "vscode"));
/**
 * Manages the account status bar item that appears at the bottom right of VS Code.
 * Clicking on it opens the VS Code Accounts menu where BlackSwan appears.
 */
class AccountStatusBarManager {
    constructor(authService) {
        this.authService = authService;
        this.disposables = [];
        // Create status bar item on the right side (where account items typically are)
        this.statusBarItem = vscode.window.createStatusBarItem(vscode.StatusBarAlignment.Right, 50);
        this.updateStatusBar();
        // Subscribe to auth state changes
        this.disposables.push(authService.onDidChangeAuthState(() => this.updateStatusBar()));
        this.statusBarItem.show();
    }
    updateStatusBar() {
        const isLoggedIn = this.authService.isLoggedIn();
        const authState = this.authService.getAuthState();
        if (isLoggedIn && authState?.user) {
            const displayName = authState.user.name || authState.user.email || 'Account';
            const initials = this.getInitials(displayName);
            this.statusBarItem.text = `$(account) ${initials}`;
            this.statusBarItem.tooltip = new vscode.MarkdownString(`**BlackSwan Account**\n\n` +
                `Signed in as **${displayName}**\n\n` +
                (authState.user.email ? `${authState.user.email}\n\n` : '') +
                `Click to manage account`);
        }
        else {
            this.statusBarItem.text = '$(account) BlackSwan';
            this.statusBarItem.tooltip = new vscode.MarkdownString(`**BlackSwan Account**\n\n` +
                `Not signed in\n\n` +
                `Click to sign in`);
        }
        // Open the native VS Code Accounts menu
        this.statusBarItem.command = 'blackswan.auth.showAccount';
        this.statusBarItem.backgroundColor = undefined;
    }
    getInitials(name) {
        const parts = name.trim().split(/\s+/);
        if (parts.length >= 2) {
            return (parts[0][0] + parts[parts.length - 1][0]).toUpperCase();
        }
        return name.substring(0, 2).toUpperCase();
    }
    dispose() {
        this.statusBarItem.dispose();
        this.disposables.forEach(d => d.dispose());
    }
}
exports.AccountStatusBarManager = AccountStatusBarManager;


/***/ }),

/***/ "./src/auth/accountView.ts":
/*!*********************************!*\
  !*** ./src/auth/accountView.ts ***!
  \*********************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) BlackSwan. All rights reserved.
 *  Licensed under the MIT License.
 *--------------------------------------------------------------------------------------------*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AccountTreeDataProvider = void 0;
const vscode = __importStar(__webpack_require__(/*! vscode */ "vscode"));
class AccountTreeDataProvider {
    constructor(authService) {
        this.authService = authService;
        this._onDidChangeTreeData = new vscode.EventEmitter();
        this.onDidChangeTreeData = this._onDidChangeTreeData.event;
        this.usageService = null;
        authService.onDidChangeAuthState(() => this.refresh());
    }
    /**
     * Set the usage service to enable usage display
     */
    setUsageService(usageService) {
        this.usageService = usageService;
        usageService.onDidChangeUsageData(() => this.refresh());
    }
    refresh() {
        this._onDidChangeTreeData.fire();
    }
    getTreeItem(element) {
        return element;
    }
    getChildren(element) {
        if (element) {
            return [];
        }
        const authState = this.authService.getAuthState();
        const items = [];
        if (authState && this.authService.isLoggedIn()) {
            // Show logged-in state with user info
            items.push(new AccountStatusItem(authState));
            // Show usage information if available
            if (this.usageService) {
                const usageData = this.usageService.getUsageData();
                items.push(new UsageItem(usageData));
            }
            items.push(new AccountActionItem('Open Account', 'blackswan.openAccount', 'dashboard', 'View account details and usage'));
            items.push(new AccountActionItem('Open Settings', 'blackswan.openSettings', 'settings-gear', 'Open BlackSwan Settings'));
            items.push(new AccountActionItem('Sign Out', 'blackswan.auth.logout', 'sign-out', 'Sign out of your BlackSwan account'));
        }
        else {
            // Show logged-out state
            items.push(new AccountStatusItem(null));
            items.push(new AccountActionItem('Sign In', 'blackswan.auth.login', 'sign-in', 'Sign in to your BlackSwan account'));
            items.push(new AccountActionItem('Open Settings', 'blackswan.openSettings', 'settings-gear', 'Open BlackSwan Settings'));
        }
        return items;
    }
}
exports.AccountTreeDataProvider = AccountTreeDataProvider;
class AccountStatusItem extends vscode.TreeItem {
    constructor(authState) {
        if (authState?.user) {
            const displayName = authState.user.name || authState.user.email || 'User';
            super(displayName, vscode.TreeItemCollapsibleState.None);
            this.description = authState.user.email && authState.user.name ? authState.user.email : 'Signed in';
            this.iconPath = new vscode.ThemeIcon('account', new vscode.ThemeColor('charts.green'));
            this.tooltip = new vscode.MarkdownString();
            this.tooltip.appendMarkdown(`### Signed in\n\n`);
            if (authState.user.name) {
                this.tooltip.appendMarkdown(`**Name:** ${authState.user.name}\n\n`);
            }
            if (authState.user.email) {
                this.tooltip.appendMarkdown(`**Email:** ${authState.user.email}\n\n`);
            }
            this.tooltip.appendMarkdown(`**ID:** \`${authState.user.id}\``);
            // Make the status item clickable to open settings
            this.command = {
                command: 'blackswan.openSettings',
                title: 'Open Settings'
            };
        }
        else {
            super('Not signed in', vscode.TreeItemCollapsibleState.None);
            this.description = 'Click to sign in';
            this.iconPath = new vscode.ThemeIcon('account', new vscode.ThemeColor('descriptionForeground'));
            this.tooltip = 'Sign in to your BlackSwan account to sync settings and unlock features';
            this.command = {
                command: 'blackswan.auth.login',
                title: 'Sign In'
            };
        }
        this.contextValue = 'accountStatus';
    }
}
class AccountActionItem extends vscode.TreeItem {
    constructor(label, command, icon, tooltip) {
        super(label, vscode.TreeItemCollapsibleState.None);
        this.iconPath = new vscode.ThemeIcon(icon);
        this.tooltip = tooltip;
        this.contextValue = 'accountAction';
        this.command = {
            command,
            title: label
        };
    }
}
class UsageItem extends vscode.TreeItem {
    constructor(usageData) {
        if (usageData && usageData.subscription.active) {
            const { meters, subscription } = usageData;
            // Find primary meter (tokens or first meter)
            const primaryMeter = meters.find(m => m.name.toLowerCase().includes('token') ||
                m.name.toLowerCase() === 'chat tokens') || meters[0];
            if (primaryMeter) {
                let usageText;
                let percentage = 0;
                if (primaryMeter.credited > 0) {
                    percentage = Math.round((primaryMeter.consumed / primaryMeter.credited) * 100);
                    usageText = `${primaryMeter.consumed.toLocaleString()} / ${primaryMeter.credited.toLocaleString()}`;
                }
                else {
                    usageText = primaryMeter.consumed.toLocaleString();
                }
                super('Usage', vscode.TreeItemCollapsibleState.None);
                this.description = usageText;
                // Choose icon color based on usage percentage
                let iconColor;
                if (percentage >= 90) {
                    iconColor = new vscode.ThemeColor('charts.red');
                }
                else if (percentage >= 70) {
                    iconColor = new vscode.ThemeColor('charts.yellow');
                }
                else {
                    iconColor = new vscode.ThemeColor('charts.blue');
                }
                this.iconPath = new vscode.ThemeIcon('pulse', iconColor);
                // Build tooltip
                const tooltip = new vscode.MarkdownString();
                tooltip.appendMarkdown(`### Usage\n\n`);
                tooltip.appendMarkdown(`**Plan:** ${subscription.plan || 'Pro'}\n\n`);
                for (const meter of meters) {
                    const meterPercent = meter.credited > 0
                        ? Math.round((meter.consumed / meter.credited) * 100)
                        : 0;
                    if (meter.credited > 0) {
                        tooltip.appendMarkdown(`**${meter.name}:** ${meter.consumed.toLocaleString()} / ${meter.credited.toLocaleString()} ${meter.unit} (${meterPercent}%)\n\n`);
                    }
                    else {
                        tooltip.appendMarkdown(`**${meter.name}:** ${meter.consumed.toLocaleString()} ${meter.unit}\n\n`);
                    }
                }
                if (subscription.currentPeriodEnd) {
                    const endDate = new Date(subscription.currentPeriodEnd);
                    tooltip.appendMarkdown(`**Resets:** ${endDate.toLocaleDateString()}`);
                }
                this.tooltip = tooltip;
            }
            else {
                super('Usage', vscode.TreeItemCollapsibleState.None);
                this.description = 'No usage yet';
                this.iconPath = new vscode.ThemeIcon('pulse', new vscode.ThemeColor('descriptionForeground'));
                this.tooltip = 'Start using BlackSwan to see your usage metrics';
            }
        }
        else if (usageData && !usageData.subscription.active) {
            super('Usage', vscode.TreeItemCollapsibleState.None);
            this.description = 'No subscription';
            this.iconPath = new vscode.ThemeIcon('pulse', new vscode.ThemeColor('descriptionForeground'));
            this.tooltip = 'Subscribe to a plan to track usage';
        }
        else {
            super('Usage', vscode.TreeItemCollapsibleState.None);
            this.description = 'Loading...';
            this.iconPath = new vscode.ThemeIcon('loading~spin');
            this.tooltip = 'Loading usage data...';
        }
        this.contextValue = 'usageStatus';
        this.command = {
            command: 'blackswan.openUsage',
            title: 'View Usage Details'
        };
    }
}


/***/ }),

/***/ "./src/auth/authService.ts":
/*!*********************************!*\
  !*** ./src/auth/authService.ts ***!
  \*********************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) BlackSwan. All rights reserved.
 *  Licensed under the MIT License.
 *--------------------------------------------------------------------------------------------*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AuthService = void 0;
const vscode = __importStar(__webpack_require__(/*! vscode */ "vscode"));
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const client_1 = __webpack_require__(/*! better-auth/client */ "./node_modules/better-auth/dist/client/index.mjs");
const plugins_1 = __webpack_require__(/*! better-auth/client/plugins */ "./node_modules/better-auth/dist/client/plugins/index.mjs");
const AUTH_STATE_KEY = 'blackswan.auth.state';
const CLIENT_ID = 'blackswan-ide';
// Default URLs for different environments
const PRODUCTION_AUTH_URL = 'https://www.blackswan.sh';
const DEVELOPMENT_AUTH_URL = 'http://localhost:3000';
class AuthService {
    constructor(context, logger) {
        this.context = context;
        this.logger = logger;
        this._onDidChangeAuthState = new vscode.EventEmitter();
        this.onDidChangeAuthState = this._onDidChangeAuthState.event;
        this.authState = null;
        this.pollingController = null;
        this.disposables = [];
        this.disposables.push(this._onDidChangeAuthState);
        this.authClient = this.createClient();
    }
    /**
     * Create a Better Auth client instance
     */
    createClient() {
        return (0, client_1.createAuthClient)({
            baseURL: this.getAuthServerUrl(),
            plugins: [(0, plugins_1.deviceAuthorizationClient)()],
        });
    }
    /**
     * Get the configured auth server URL
     * Uses localhost in development mode, production URL otherwise
     * Can be overridden via settings
     */
    getAuthServerUrl() {
        const config = vscode.workspace.getConfiguration('blackswan.auth');
        const configuredUrl = config.get('serverUrl');
        if (configuredUrl) {
            return configuredUrl;
        }
        // Use localhost in development mode, production URL otherwise
        const isProduction = this.context.extensionMode === vscode_1.ExtensionMode.Production;
        return isProduction ? PRODUCTION_AUTH_URL : DEVELOPMENT_AUTH_URL;
    }
    /**
     * Recreate auth client with updated URL (if settings change)
     */
    updateAuthClient() {
        this.authClient = this.createClient();
    }
    /**
     * Initialize the auth service and restore saved state
     */
    async initialize() {
        try {
            const storedState = await this.context.secrets.get(AUTH_STATE_KEY);
            if (storedState) {
                this.authState = JSON.parse(storedState);
                this.logger.info('Restored auth state from secrets');
                // Validate the token is still valid
                if (this.authState && this.isTokenExpired()) {
                    this.logger.info('Stored token is expired, clearing state');
                    await this.logout();
                }
                else {
                    this._onDidChangeAuthState.fire(this.authState);
                }
            }
        }
        catch (error) {
            this.logger.error(`Failed to restore auth state: ${error}`);
        }
    }
    /**
     * Check if the current token is expired
     */
    isTokenExpired() {
        if (!this.authState?.expiresAt) {
            return false;
        }
        // Add 5 minute buffer
        return Date.now() > (this.authState.expiresAt - 5 * 60 * 1000);
    }
    /**
     * Get the current auth state
     */
    getAuthState() {
        return this.authState;
    }
    /**
     * Check if user is logged in
     */
    isLoggedIn() {
        return this.authState !== null && !this.isTokenExpired();
    }
    /**
     * Start the device authorization flow using Better Auth client
     */
    async login() {
        // Ensure client is using current server URL
        this.updateAuthClient();
        this.logger.info(`Starting device authorization flow with server: ${this.getAuthServerUrl()}`);
        try {
            // Step 1: Request device code using Better Auth client
            const deviceCodeResult = await this.authClient.device.code({
                client_id: CLIENT_ID,
                scope: 'openid profile email',
            });
            this.logger.info(`Device code response: ${JSON.stringify(deviceCodeResult)}`);
            if (deviceCodeResult.error || !deviceCodeResult.data) {
                const errorMsg = deviceCodeResult.error?.error_description ||
                    deviceCodeResult.error?.message ||
                    deviceCodeResult.error?.error ||
                    'Unknown error';
                this.logger.error(`Failed to get device code: ${errorMsg}`);
                vscode.window.showErrorMessage(`Failed to start login: ${errorMsg}`);
                return false;
            }
            const { device_code, user_code, verification_uri, verification_uri_complete, interval = 5, } = deviceCodeResult.data;
            // Step 2: Show user the code and open browser
            const userAction = await this.showDeviceCodePrompt({
                user_code,
                verification_uri,
                verification_uri_complete,
            });
            if (!userAction) {
                this.logger.info('User cancelled device authorization');
                return false;
            }
            // Step 3: Poll for token using Better Auth client
            const tokenResult = await this.pollForToken(device_code, interval);
            if (!tokenResult) {
                return false;
            }
            // Step 4: Extract user from token response or fetch separately
            let user = tokenResult.user;
            // If no user in token response, try to get session
            this.logger.info(`Fetching user with token: ${JSON.stringify(tokenResult)}`);
            if (tokenResult.access_token) {
                user = await this.fetchUserWithToken(tokenResult.access_token);
            }
            // Step 5: Save auth state
            this.authState = {
                accessToken: tokenResult.access_token,
                refreshToken: tokenResult.refresh_token,
                expiresAt: tokenResult.expires_in
                    ? Date.now() + tokenResult.expires_in * 1000
                    : undefined,
                user,
            };
            this.logger.info(`Auth state saved with user: ${JSON.stringify(user)}`);
            await this.saveAuthState();
            this._onDidChangeAuthState.fire(this.authState);
            vscode.window.showInformationMessage(`Welcome, ${this.authState.user?.name || this.authState.user?.email || 'User'}!`);
            return true;
        }
        catch (error) {
            this.logger.error(`Device authorization failed: ${error}`);
            vscode.window.showErrorMessage(`Login failed: ${error}`);
            return false;
        }
    }
    /**
     * Decode JWT payload (without verification - just for extracting claims)
     */
    decodeJwtPayload(token) {
        try {
            const parts = token.split('.');
            if (parts.length !== 3) {
                return undefined;
            }
            // Decode base64url payload
            const payload = parts[1]
                .replace(/-/g, '+')
                .replace(/_/g, '/');
            const decoded = Buffer.from(payload, 'base64').toString('utf-8');
            return JSON.parse(decoded);
        }
        catch (error) {
            this.logger.warn(`Failed to decode JWT: ${error}`);
            return undefined;
        }
    }
    /**
     * Fetch user info using access token via Better Auth client
     */
    async fetchUserWithToken(accessToken) {
        try {
            // Use Better Auth client's getSession with custom headers
            const sessionResult = await this.authClient.getSession({
                fetchOptions: {
                    headers: {
                        Authorization: `Bearer ${accessToken}`,
                    },
                },
            });
            this.logger.info(`Session result: ${JSON.stringify(sessionResult)}`);
            if (sessionResult.data?.user) {
                const serverUser = sessionResult.data.user;
                // If we got user data from session, use it
                if (serverUser.id && (serverUser.name || serverUser.email)) {
                    return {
                        id: serverUser.id.toString(),
                        name: serverUser.name || undefined,
                        email: serverUser.email || undefined,
                        image: serverUser.image || undefined,
                    };
                }
            }
            // Fallback: Try to decode JWT to get user claims
            this.logger.info('Session did not return complete user info, trying JWT decode...');
            const jwtPayload = this.decodeJwtPayload(accessToken);
            this.logger.info(`JWT payload: ${JSON.stringify(jwtPayload)}`);
            if (jwtPayload) {
                // Common JWT claim names for user info
                const id = (jwtPayload.sub || jwtPayload.id || jwtPayload.userId || jwtPayload.user_id);
                const name = (jwtPayload.name || jwtPayload.preferred_username || jwtPayload.username);
                const email = (jwtPayload.email);
                const image = (jwtPayload.picture || jwtPayload.avatar || jwtPayload.image);
                if (id) {
                    return {
                        id: id.toString(),
                        name: name || undefined,
                        email: email || undefined,
                        image: image || undefined,
                    };
                }
            }
            // Last resort: return partial user from session if available
            if (sessionResult.data?.user?.id) {
                return {
                    id: sessionResult.data.user.id.toString(),
                    name: sessionResult.data.user.name || undefined,
                    email: sessionResult.data.user.email || undefined,
                    image: sessionResult.data.user.image || undefined,
                };
            }
            return undefined;
        }
        catch (error) {
            this.logger.warn(`Failed to fetch user with token: ${error}`);
            return undefined;
        }
    }
    /**
     * Show the device code to the user and offer to open browser
     */
    async showDeviceCodePrompt(response) {
        const openBrowser = 'Open Browser';
        const copyCode = 'Copy Code';
        const result = await vscode.window.showInformationMessage(`To sign in, visit ${response.verification_uri} and enter code: ${response.user_code}`, { modal: true }, openBrowser, copyCode);
        if (result === openBrowser) {
            const urlToOpen = response.verification_uri_complete || response.verification_uri;
            await vscode.env.openExternal(vscode.Uri.parse(urlToOpen));
            await vscode.env.clipboard.writeText(response.user_code);
            vscode.window.showInformationMessage(`Code ${response.user_code} copied to clipboard`);
            return true;
        }
        else if (result === copyCode) {
            await vscode.env.clipboard.writeText(response.user_code);
            vscode.window.showInformationMessage(`Code ${response.user_code} copied to clipboard`);
            return true;
        }
        return false;
    }
    /**
     * Poll the token endpoint until authorization is complete using Better Auth client
     */
    async pollForToken(deviceCode, interval) {
        this.pollingController = new AbortController();
        let pollingInterval = interval;
        return vscode.window.withProgress({
            location: vscode.ProgressLocation.Notification,
            title: 'Waiting for authorization...',
            cancellable: true
        }, async (_progress, token) => {
            token.onCancellationRequested(() => {
                this.pollingController?.abort();
            });
            while (!this.pollingController?.signal.aborted) {
                await this.sleep(pollingInterval * 1000);
                if (this.pollingController?.signal.aborted) {
                    return null;
                }
                try {
                    // Use Better Auth client to poll for token
                    const result = await this.authClient.device.token({
                        grant_type: 'urn:ietf:params:oauth:grant-type:device_code',
                        device_code: deviceCode,
                        client_id: CLIENT_ID,
                    });
                    this.logger.info(`Device token result: ${JSON.stringify(result)}`);
                    if (result.data?.access_token) {
                        this.logger.info('Authorization successful!');
                        return {
                            access_token: result.data.access_token,
                            refresh_token: result.data.refresh_token,
                            expires_in: result.data.expires_in,
                            user: result.data.user ? {
                                id: result.data.user.id,
                                name: result.data.user.name,
                                email: result.data.user.email,
                                image: result.data.user.image,
                            } : undefined,
                        };
                    }
                    if (result.error) {
                        const errorCode = result.error.error;
                        switch (errorCode) {
                            case 'authorization_pending':
                                // Continue polling silently
                                break;
                            case 'slow_down':
                                pollingInterval += 5;
                                this.logger.info(`Slowing down polling to ${pollingInterval}s`);
                                break;
                            case 'access_denied':
                                vscode.window.showErrorMessage('Access was denied by the user');
                                return null;
                            case 'expired_token':
                                vscode.window.showErrorMessage('The device code has expired. Please try again.');
                                return null;
                            default:
                                this.logger.warn(`Polling warning: ${result.error.error_description || result.error.error}`);
                        }
                    }
                }
                catch (err) {
                    if (err.name === 'AbortError') {
                        return null;
                    }
                    this.logger.error(`Polling error: ${err}`);
                }
            }
            return null;
        });
    }
    /**
     * Log out the current user using Better Auth client
     */
    async logout() {
        try {
            if (this.authState?.accessToken) {
                await this.authClient.signOut({
                    fetchOptions: {
                        headers: {
                            Authorization: `Bearer ${this.authState.accessToken}`,
                        },
                    },
                });
            }
        }
        catch (error) {
            this.logger.warn(`Server logout failed (may be expected): ${error}`);
        }
        this.authState = null;
        await this.context.secrets.delete(AUTH_STATE_KEY);
        this._onDidChangeAuthState.fire(null);
        vscode.window.showInformationMessage('You have been logged out');
    }
    /**
     * Save the current auth state to secrets
     */
    async saveAuthState() {
        if (this.authState) {
            await this.context.secrets.store(AUTH_STATE_KEY, JSON.stringify(this.authState));
        }
    }
    /**
     * Get the access token for API calls
     */
    getAccessToken() {
        if (!this.isLoggedIn()) {
            return null;
        }
        return this.authState?.accessToken || null;
    }
    /**
     * Get the Better Auth client for direct API access
     */
    getAuthClient() {
        return this.authClient;
    }
    /**
     * Helper to sleep for a given number of milliseconds
     */
    sleep(ms) {
        return new Promise(resolve => setTimeout(resolve, ms));
    }
    dispose() {
        this.pollingController?.abort();
        this.disposables.forEach(d => d.dispose());
    }
}
exports.AuthService = AuthService;


/***/ }),

/***/ "./src/auth/authenticationProvider.ts":
/*!********************************************!*\
  !*** ./src/auth/authenticationProvider.ts ***!
  \********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) BlackSwan. All rights reserved.
 *  Licensed under the MIT License.
 *--------------------------------------------------------------------------------------------*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BlackSwanAuthenticationProvider = exports.AUTH_PROVIDER_LABEL = exports.AUTH_PROVIDER_ID = void 0;
exports.registerAuthenticationProvider = registerAuthenticationProvider;
const vscode = __importStar(__webpack_require__(/*! vscode */ "vscode"));
exports.AUTH_PROVIDER_ID = 'blackswan';
exports.AUTH_PROVIDER_LABEL = 'BlackSwan';
/**
 * VS Code Authentication Provider for BlackSwan.
 * This makes BlackSwan appear in the native Accounts menu alongside GitHub, Microsoft, etc.
 */
class BlackSwanAuthenticationProvider {
    constructor(context, authService, logger) {
        this.context = context;
        this.authService = authService;
        this.logger = logger;
        this._onDidChangeSessions = new vscode.EventEmitter();
        this.onDidChangeSessions = this._onDidChangeSessions.event;
        this.disposables = [];
        this.disposables.push(this._onDidChangeSessions);
        // Listen to auth state changes and emit session changes
        this.disposables.push(authService.onDidChangeAuthState((state) => {
            if (state) {
                // Session added
                this._onDidChangeSessions.fire({
                    added: [this.authStateToSession(state)],
                    removed: [],
                    changed: []
                });
            }
            else {
                // Session removed - fire with empty removed array since we don't have the old session
                this._onDidChangeSessions.fire({
                    added: [],
                    removed: [],
                    changed: []
                });
            }
        }));
    }
    /**
     * Get existing sessions
     */
    async getSessions(scopes) {
        const authState = this.authService.getAuthState();
        if (!authState || !this.authService.isLoggedIn()) {
            return [];
        }
        return [this.authStateToSession(authState)];
    }
    /**
     * Create a new session (login)
     */
    async createSession(scopes) {
        // Called by VS Code to create a new session (login flow)
        this.logger.info('Creating new BlackSwan session via native auth provider');
        const success = await this.authService.login();
        if (!success) {
            throw new Error('Login was cancelled or failed');
        }
        const authState = this.authService.getAuthState();
        if (!authState) {
            throw new Error('No auth state after successful login');
        }
        return this.authStateToSession(authState);
    }
    /**
     * Convert auth state to VS Code session
     */
    authStateToSession(authState) {
        const user = authState.user;
        return {
            id: user?.id || 'blackswan-session',
            accessToken: authState.accessToken,
            account: {
                id: user?.id || 'unknown',
                label: user?.name || user?.email || 'BlackSwan User'
            },
            scopes: ['openid', 'profile', 'email']
        };
    }
    /**
     * Remove a session (logout)
     */
    async removeSession(sessionId) {
        this.logger.info(`Removing BlackSwan session: ${sessionId}`);
        await this.authService.logout();
    }
    dispose() {
        this.disposables.forEach(d => d.dispose());
    }
}
exports.BlackSwanAuthenticationProvider = BlackSwanAuthenticationProvider;
/**
 * Register the BlackSwan authentication provider with VS Code
 */
function registerAuthenticationProvider(context, authService, logger) {
    const provider = new BlackSwanAuthenticationProvider(context, authService, logger);
    context.subscriptions.push(vscode.authentication.registerAuthenticationProvider(exports.AUTH_PROVIDER_ID, exports.AUTH_PROVIDER_LABEL, provider, {
        supportsMultipleAccounts: false
    }));
    context.subscriptions.push(provider);
    logger.info('Registered BlackSwan authentication provider');
    return provider;
}


/***/ }),

/***/ "./src/auth/commands.ts":
/*!******************************!*\
  !*** ./src/auth/commands.ts ***!
  \******************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) BlackSwan. All rights reserved.
 *  Licensed under the MIT License.
 *--------------------------------------------------------------------------------------------*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AuthCommandCenter = void 0;
const vscode = __importStar(__webpack_require__(/*! vscode */ "vscode"));
const authenticationProvider_1 = __webpack_require__(/*! ./authenticationProvider */ "./src/auth/authenticationProvider.ts");
class AuthCommandCenter {
    constructor(authService, accountProvider, // Can be null when using webview
    logger) {
        this.authService = authService;
        this.accountProvider = accountProvider;
        this.logger = logger;
        this.disposables = [];
    }
    registerCommands(context) {
        this.register('blackswan.auth.login', () => this.login());
        this.register('blackswan.auth.logout', () => this.logout());
        this.register('blackswan.auth.showAccount', () => this.showAccount());
        context.subscriptions.push(...this.disposables);
    }
    register(command, callback) {
        this.disposables.push(vscode.commands.registerCommand(command, callback));
    }
    async login() {
        this.logger.info('Starting login flow via native authentication');
        try {
            // Use VS Code's native authentication API - this triggers the authentication provider
            const session = await vscode.authentication.getSession(authenticationProvider_1.AUTH_PROVIDER_ID, ['openid', 'profile', 'email'], {
                createIfNone: true
            });
            if (session) {
                this.logger.info(`Login successful: ${session.account.label}`);
                vscode.commands.executeCommand('setContext', 'blackswan.auth.isLoggedIn', true);
            }
        }
        catch (error) {
            this.logger.error(`Login failed: ${error}`);
        }
    }
    async logout() {
        this.logger.info('Logging out');
        await this.authService.logout();
        vscode.commands.executeCommand('setContext', 'blackswan.auth.isLoggedIn', false);
    }
    async showAccount() {
        // If logged in, show account management options
        if (this.authService.isLoggedIn()) {
            const authState = this.authService.getAuthState();
            const displayName = authState?.user?.name || authState?.user?.email || 'User';
            const choice = await vscode.window.showQuickPick([
                {
                    label: `$(account) ${displayName}`,
                    description: authState?.user?.email || 'Signed in to BlackSwan',
                    detail: 'Currently signed in',
                    action: 'info'
                },
                {
                    label: '$(settings-gear) Open Settings',
                    description: 'Configure BlackSwan settings',
                    action: 'settings'
                },
                {
                    label: '$(sign-out) Sign Out',
                    description: 'Sign out of BlackSwan',
                    action: 'logout'
                }
            ], {
                title: 'BlackSwan Account',
                placeHolder: 'Manage your BlackSwan account'
            });
            if (choice?.action === 'logout') {
                await this.logout();
            }
            else if (choice?.action === 'settings') {
                vscode.commands.executeCommand('blackswan.openSettings');
            }
            else if (choice?.action === 'info') {
                vscode.commands.executeCommand('blackswan.openAccount');
            }
        }
        else {
            // Not logged in - offer to sign in
            const choice = await vscode.window.showQuickPick([
                {
                    label: '$(sign-in) Sign In to BlackSwan',
                    description: 'Sign in with your BlackSwan account',
                    action: 'login'
                },
                {
                    label: '$(settings-gear) Open Settings',
                    description: 'Configure BlackSwan settings',
                    action: 'settings'
                }
            ], {
                title: 'BlackSwan Account',
                placeHolder: 'Sign in to access all features'
            });
            if (choice?.action === 'login') {
                await this.login();
            }
            else if (choice?.action === 'settings') {
                vscode.commands.executeCommand('blackswan.openSettings');
            }
        }
    }
    dispose() {
        this.disposables.forEach(d => d.dispose());
    }
}
exports.AuthCommandCenter = AuthCommandCenter;


/***/ }),

/***/ "./src/auth/index.ts":
/*!***************************!*\
  !*** ./src/auth/index.ts ***!
  \***************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) BlackSwan. All rights reserved.
 *  Licensed under the MIT License.
 *--------------------------------------------------------------------------------------------*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AUTH_PROVIDER_LABEL = exports.AUTH_PROVIDER_ID = exports.registerAuthenticationProvider = exports.BlackSwanAuthenticationProvider = exports.AuthCommandCenter = exports.AccountStatusBarManager = exports.AccountTreeDataProvider = exports.UsageService = exports.AuthService = void 0;
var authService_1 = __webpack_require__(/*! ./authService */ "./src/auth/authService.ts");
Object.defineProperty(exports, "AuthService", ({ enumerable: true, get: function () { return authService_1.AuthService; } }));
var usageService_1 = __webpack_require__(/*! ./usageService */ "./src/auth/usageService.ts");
Object.defineProperty(exports, "UsageService", ({ enumerable: true, get: function () { return usageService_1.UsageService; } }));
var accountView_1 = __webpack_require__(/*! ./accountView */ "./src/auth/accountView.ts");
Object.defineProperty(exports, "AccountTreeDataProvider", ({ enumerable: true, get: function () { return accountView_1.AccountTreeDataProvider; } }));
var accountStatusBar_1 = __webpack_require__(/*! ./accountStatusBar */ "./src/auth/accountStatusBar.ts");
Object.defineProperty(exports, "AccountStatusBarManager", ({ enumerable: true, get: function () { return accountStatusBar_1.AccountStatusBarManager; } }));
var commands_1 = __webpack_require__(/*! ./commands */ "./src/auth/commands.ts");
Object.defineProperty(exports, "AuthCommandCenter", ({ enumerable: true, get: function () { return commands_1.AuthCommandCenter; } }));
var authenticationProvider_1 = __webpack_require__(/*! ./authenticationProvider */ "./src/auth/authenticationProvider.ts");
Object.defineProperty(exports, "BlackSwanAuthenticationProvider", ({ enumerable: true, get: function () { return authenticationProvider_1.BlackSwanAuthenticationProvider; } }));
Object.defineProperty(exports, "registerAuthenticationProvider", ({ enumerable: true, get: function () { return authenticationProvider_1.registerAuthenticationProvider; } }));
Object.defineProperty(exports, "AUTH_PROVIDER_ID", ({ enumerable: true, get: function () { return authenticationProvider_1.AUTH_PROVIDER_ID; } }));
Object.defineProperty(exports, "AUTH_PROVIDER_LABEL", ({ enumerable: true, get: function () { return authenticationProvider_1.AUTH_PROVIDER_LABEL; } }));
__exportStar(__webpack_require__(/*! ./types */ "./src/auth/types.ts"), exports);


/***/ }),

/***/ "./src/auth/types.ts":
/*!***************************!*\
  !*** ./src/auth/types.ts ***!
  \***************************/
/***/ ((__unused_webpack_module, exports) => {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) BlackSwan. All rights reserved.
 *  Licensed under the MIT License.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),

/***/ "./src/auth/usageService.ts":
/*!**********************************!*\
  !*** ./src/auth/usageService.ts ***!
  \**********************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) BlackSwan. All rights reserved.
 *  Licensed under the MIT License.
 *--------------------------------------------------------------------------------------------*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UsageService = void 0;
const vscode = __importStar(__webpack_require__(/*! vscode */ "vscode"));
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
// Default URLs for different environments
const PRODUCTION_API_URL = 'https://www.blackswan.sh';
const DEVELOPMENT_API_URL = 'http://localhost:3000';
function inferUnitFromMeterName(name) {
    const lowerName = name.toLowerCase();
    if (lowerName.includes('token') || lowerName === 'llm')
        return 'tokens';
    if (lowerName.includes('request'))
        return 'requests';
    if (lowerName.includes('byte'))
        return 'bytes';
    if (lowerName.includes('call'))
        return 'calls';
    if (lowerName.includes('credit'))
        return 'credits';
    return 'units';
}
function formatMeterDisplayName(name) {
    const lowerName = name.toLowerCase();
    if (lowerName === 'llm')
        return 'Chat tokens';
    return name;
}
/**
 * Service to fetch usage data from the BlackSwan API using Better Auth Polar endpoints
 */
class UsageService {
    constructor(context, authService, logger) {
        this.context = context;
        this.authService = authService;
        this.logger = logger;
        this._onDidChangeUsageData = new vscode.EventEmitter();
        this.onDidChangeUsageData = this._onDidChangeUsageData.event;
        this.usageData = null;
        this.disposables = [];
        this.refreshInterval = null;
        this.disposables.push(this._onDidChangeUsageData);
        // Refresh usage data when auth state changes
        this.disposables.push(authService.onDidChangeAuthState(() => {
            if (authService.isLoggedIn()) {
                void this.refreshUsageData();
            }
            else {
                this.usageData = null;
                this._onDidChangeUsageData.fire(null);
            }
        }));
        // Start periodic refresh (every 5 minutes)
        this.startPeriodicRefresh();
    }
    /**
     * Get the API server URL
     */
    getApiServerUrl() {
        const config = vscode.workspace.getConfiguration('blackswan.auth');
        const configuredUrl = config.get('serverUrl');
        if (configuredUrl) {
            return configuredUrl;
        }
        const isProduction = this.context.extensionMode === vscode_1.ExtensionMode.Production;
        return isProduction ? PRODUCTION_API_URL : DEVELOPMENT_API_URL;
    }
    /**
     * Start periodic refresh of usage data
     */
    startPeriodicRefresh() {
        // Refresh every 5 minutes
        this.refreshInterval = setInterval(() => {
            if (this.authService.isLoggedIn()) {
                void this.refreshUsageData();
            }
        }, 5 * 60 * 1000);
    }
    /**
     * Refresh usage data from the Better Auth Polar endpoints
     */
    async refreshUsageData() {
        if (!this.authService.isLoggedIn()) {
            this.usageData = null;
            this._onDidChangeUsageData.fire(null);
            return null;
        }
        const accessToken = this.authService.getAccessToken();
        if (!accessToken) {
            this.logger.warn('No access token available for usage data fetch');
            return null;
        }
        const apiUrl = this.getApiServerUrl();
        const headers = {
            'Authorization': `Bearer ${accessToken}`,
            'Content-Type': 'application/json',
        };
        let meters = [];
        let subscription = { active: false };
        let currency = 'USD';
        // Fetch customer state (subscription info)
        try {
            const stateResponse = await fetch(`${apiUrl}/api/auth/customer/state`, {
                method: 'GET',
                headers,
            });
            if (stateResponse.ok) {
                const stateData = await stateResponse.json();
                // Handle various response formats from Polar
                const stateObj = stateData?.state || {};
                const subscriptions = stateData?.activeSubscriptions ||
                    stateData?.active_subscriptions ||
                    stateData?.subscriptions ||
                    stateObj?.activeSubscriptions ||
                    stateObj?.subscriptions ||
                    [];
                const activeSub = Array.isArray(subscriptions) ? subscriptions[0] : null;
                if (activeSub) {
                    subscription = {
                        active: true,
                        plan: activeSub.product?.name || 'Pro',
                        currentPeriodEnd: activeSub.currentPeriodEnd || activeSub.current_period_end,
                    };
                    // Get currency from subscription
                    const subCurrency = activeSub.price?.priceCurrency || activeSub.price?.price_currency;
                    if (subCurrency) {
                        currency = subCurrency.toUpperCase();
                    }
                }
            }
        }
        catch (stateError) {
            this.logger.warn(`Could not fetch customer state: ${stateError}`);
        }
        // Fetch usage meters
        try {
            const metersResponse = await fetch(`${apiUrl}/api/auth/usage/meters/list?page=1&limit=100`, {
                method: 'GET',
                headers,
            });
            if (metersResponse.ok) {
                const metersData = await metersResponse.json();
                // Handle various response formats
                const resultObj = metersData?.result || {};
                const items = (resultObj?.items || metersData?.items || metersData || []);
                if (Array.isArray(items)) {
                    meters = items.map((cm) => {
                        const originalName = cm.meter?.name?.toLowerCase() || '';
                        // Calculate amount due: balance represents the amount owed (positive balance = amount due)
                        // If balance is negative, it means credits/prepaid, so amount due is 0
                        const amountDue = Math.max(0, -(cm.balance || 0));
                        return {
                            id: cm.id,
                            name: formatMeterDisplayName(cm.meter?.name || 'Unknown'),
                            consumed: cm.consumedUnits || 0,
                            credited: cm.creditedUnits || 0,
                            balance: cm.balance || 0,
                            unit: originalName === 'llm' ? 'tokens' : inferUnitFromMeterName(cm.meter?.name || ''),
                            amountDue,
                        };
                    });
                }
            }
        }
        catch (metersError) {
            // Customer might not exist in Polar yet - this is OK
            const errorMessage = String(metersError);
            if (!errorMessage.includes('customer does not exist') &&
                !errorMessage.includes('external_customer_id')) {
                this.logger.warn(`Could not fetch usage meters: ${metersError}`);
            }
        }
        this.usageData = { meters, subscription, currency };
        this._onDidChangeUsageData.fire(this.usageData);
        this.logger.info('Usage data refreshed successfully');
        return this.usageData;
    }
    /**
     * Get the current usage data (cached)
     */
    getUsageData() {
        return this.usageData;
    }
    /**
     * Format usage for display in tree view
     */
    formatUsageSummary() {
        if (!this.usageData) {
            return 'No usage data';
        }
        const { meters, subscription } = this.usageData;
        if (!subscription.active) {
            return 'No active subscription';
        }
        if (meters.length === 0) {
            return 'No usage yet';
        }
        // Show primary meter (usually LLM tokens)
        const primaryMeter = meters.find(m => m.name.toLowerCase().includes('token') || m.name.toLowerCase() === 'chat tokens') || meters[0];
        if (primaryMeter.credited > 0) {
            const percentage = Math.round((primaryMeter.consumed / primaryMeter.credited) * 100);
            return `${primaryMeter.consumed.toLocaleString()} / ${primaryMeter.credited.toLocaleString()} ${primaryMeter.unit} (${percentage}%)`;
        }
        return `${primaryMeter.consumed.toLocaleString()} ${primaryMeter.unit}`;
    }
    dispose() {
        if (this.refreshInterval) {
            clearInterval(this.refreshInterval);
        }
        this.disposables.forEach(d => d.dispose());
    }
}
exports.UsageService = UsageService;


/***/ }),

/***/ "./src/chat/chatAgentAutoSelector.ts":
/*!*******************************************!*\
  !*** ./src/chat/chatAgentAutoSelector.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, exports) => {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) BlackSwan. All rights reserved.
 *  Licensed under the MIT License.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChatAgentAutoSelector = void 0;
/**
 * Ensures a chat agent/mode is selected, retrying with backoff until it succeeds or is disposed.
 *
 * Why this exists:
 * - `vscode.chat.selectChatAgent(...)` can return `false` early in extension activation, e.g.
 *   when the chat widget doesn't exist yet or chat modes/custom agents haven't hydrated.
 */
class ChatAgentAutoSelector {
    static { this.defaultOptions = {
        initialDelayMs: 200,
        maxDelayMs: 10_000,
        backoffMultiplier: 2,
        jitterRatio: 0.2,
        warnAfterMs: 15_000,
        giveUpAfterMs: 20_000
    }; }
    constructor(agentId, attemptSelect, logger, options) {
        this.agentId = agentId;
        this.attemptSelect = attemptSelect;
        this.logger = logger;
        this.disposed = false;
        this.hasLoggedWarn = false;
        this.options = { ...ChatAgentAutoSelector.defaultOptions, ...(options ?? {}) };
    }
    /**
     * Request selection of the agent. Multiple requests are coalesced into a single retry loop.
     */
    requestSelection() {
        if (this.disposed) {
            return Promise.resolve(false);
        }
        if (!this.inFlightSelection) {
            this.inFlightSelection = this.runSelectionLoop().finally(() => {
                this.inFlightSelection = undefined;
                this.hasLoggedWarn = false;
            });
        }
        return this.inFlightSelection;
    }
    async runSelectionLoop() {
        const startedAt = Date.now();
        let attempt = 0;
        let loggedInitialRetryMessage = false;
        while (!this.disposed) {
            let selected = false;
            try {
                selected = await this.attemptSelect(this.agentId);
            }
            catch (error) {
                // Actual API failure, not an expected "false" response.
                this.logger.warn(`Failed to select chat agent "${this.agentId}": ${error}`);
            }
            if (selected) {
                if (attempt > 0) {
                    this.logger.info(`Selected chat agent "${this.agentId}" after ${attempt} retry attempt(s)`);
                }
                return true;
            }
            if (!loggedInitialRetryMessage) {
                loggedInitialRetryMessage = true;
                this.logger.debug(`Chat agent "${this.agentId}" not selectable yet. Will retry until available.`);
            }
            const elapsedMs = Date.now() - startedAt;
            if (elapsedMs >= this.options.giveUpAfterMs) {
                this.logger.debug(`Giving up on selecting chat agent "${this.agentId}" after ${elapsedMs}ms`);
                return false;
            }
            if (!this.hasLoggedWarn && elapsedMs >= this.options.warnAfterMs) {
                this.hasLoggedWarn = true;
                this.logger.warn(`Still unable to select chat agent "${this.agentId}". ` +
                    'This can happen if the chat UI has not been opened yet or modes are still loading. ' +
                    'Will keep retrying for a while in the background.');
            }
            const delayMs = this.getDelayMs(attempt);
            await this.delay(delayMs);
            attempt++;
        }
        return false;
    }
    getDelayMs(attempt) {
        const exponential = this.options.initialDelayMs * Math.pow(this.options.backoffMultiplier, attempt);
        const capped = Math.min(this.options.maxDelayMs, exponential);
        const jitterScale = this.options.jitterRatio <= 0 ? 1 : (1 - this.options.jitterRatio) + (Math.random() * 2 * this.options.jitterRatio);
        return Math.max(0, Math.round(capped * jitterScale));
    }
    delay(ms) {
        if (this.disposed || ms <= 0) {
            return Promise.resolve();
        }
        return new Promise(resolve => {
            const timer = setTimeout(() => {
                if (this.pendingDelay?.timer === timer) {
                    this.pendingDelay = undefined;
                }
                resolve();
            }, ms);
            this.pendingDelay = { timer, resolve };
        });
    }
    dispose() {
        this.disposed = true;
        // Cancel any pending delay so the selection loop can exit promptly.
        const delay = this.pendingDelay;
        if (delay) {
            clearTimeout(delay.timer);
            delay.resolve();
            this.pendingDelay = undefined;
        }
    }
}
exports.ChatAgentAutoSelector = ChatAgentAutoSelector;


/***/ }),

/***/ "./src/chat/index.ts":
/*!***************************!*\
  !*** ./src/chat/index.ts ***!
  \***************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) BlackSwan. All rights reserved.
 *  Licensed under the MIT License.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.registerPentestModeProvider = exports.PentestModeProvider = void 0;
var pentestModeProvider_1 = __webpack_require__(/*! ./pentestModeProvider */ "./src/chat/pentestModeProvider.ts");
Object.defineProperty(exports, "PentestModeProvider", ({ enumerable: true, get: function () { return pentestModeProvider_1.PentestModeProvider; } }));
Object.defineProperty(exports, "registerPentestModeProvider", ({ enumerable: true, get: function () { return pentestModeProvider_1.registerPentestModeProvider; } }));


/***/ }),

/***/ "./src/chat/pentestModeProvider.ts":
/*!*****************************************!*\
  !*** ./src/chat/pentestModeProvider.ts ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) BlackSwan. All rights reserved.
 *  Licensed under the MIT License.
 *--------------------------------------------------------------------------------------------*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PentestModeProvider = void 0;
exports.registerPentestModeProvider = registerPentestModeProvider;
const vscode = __importStar(__webpack_require__(/*! vscode */ "vscode"));
const chatAgentAutoSelector_1 = __webpack_require__(/*! ./chatAgentAutoSelector */ "./src/chat/chatAgentAutoSelector.ts");
/**
 * Provider that supplies the Pentest custom agent mode.
 * This makes "Pentest" appear in VS Code's chat mode dropdown.
 */
class PentestModeProvider {
    /** The name of the Pentest agent as it appears in the dropdown */
    static { this.agentName = 'Pentest'; }
    constructor(extensionUri, logger) {
        this.extensionUri = extensionUri;
        this.logger = logger;
        this.disposables = [];
        this._onDidChangeCustomAgents = new vscode.EventEmitter();
        this.onDidChangeCustomAgents = this._onDidChangeCustomAgents.event;
        this.hasRegisteredCustomAgentsProvider = false;
    }
    /**
     * Provides the list of custom agent resources (Pentest mode).
     */
    async provideCustomAgents(_options, _token) {
        const agentUri = vscode.Uri.joinPath(this.extensionUri, 'prompts', 'pentest.agent.md');
        // Verify the file exists
        try {
            await vscode.workspace.fs.stat(agentUri);
        }
        catch {
            this.logger.warn(`Pentest agent file not found at ${agentUri.fsPath}`);
            return [];
        }
        return [{
                name: PentestModeProvider.agentName,
                description: 'Security testing assistant with HTTP request context',
                uri: agentUri,
                isEditable: false
            }];
    }
    /**
     * Registers this provider with VS Code's chat system.
     * Uses the proposed API chat.registerCustomAgentsProvider.
     */
    register() {
        this.hasRegisteredCustomAgentsProvider = false;
        const chatNamespace = vscode.chat;
        // Check if the proposed API is available
        if (typeof chatNamespace.registerCustomAgentsProvider !== 'function') {
            this.logger.warn('chat.registerCustomAgentsProvider is not available. Pentest mode will not appear in the dropdown.');
            this.logger.info('This requires the chatParticipantPrivate proposed API to be enabled.');
            return;
        }
        try {
            const disposable = chatNamespace.registerCustomAgentsProvider({
                onDidChangeCustomAgents: this.onDidChangeCustomAgents,
                provideCustomAgents: this.provideCustomAgents.bind(this)
            });
            this.disposables.push(disposable);
            this.hasRegisteredCustomAgentsProvider = true;
            this.logger.info('Pentest mode provider registered successfully');
        }
        catch (error) {
            this.logger.error(`Failed to register Pentest mode provider: ${error}`);
        }
    }
    isAgentModeEnabled() {
        // Custom agents are only discoverable/selectable when agent mode is enabled.
        // When disabled, attempting to select a custom agent results in noisy VS Code warnings.
        return !!vscode.workspace.getConfiguration('chat').get('agent.enabled');
    }
    /**
     * Selects the Pentest agent as the active chat mode.
     * This should be called when a security-related context is opened (e.g., HTTP request tab).
     * @returns A promise that resolves to `true` if the agent was successfully selected, `false` otherwise.
     */
    async selectAgent() {
        const chatNamespace = vscode.chat;
        // Check if the selectChatAgent API is available
        if (typeof chatNamespace.selectChatAgent !== 'function') {
            this.logger.warn('chat.selectChatAgent is not available.');
            return false;
        }
        if (!this.isAgentModeEnabled()) {
            this.logger.debug('Chat agent mode is disabled (chat.agent.enabled=false). Skipping Pentest agent selection.');
            return false;
        }
        try {
            if (!this.agentAutoSelector) {
                this.agentAutoSelector = new chatAgentAutoSelector_1.ChatAgentAutoSelector(PentestModeProvider.agentName, (agentId) => chatNamespace.selectChatAgent(agentId), this.logger);
                this.disposables.push(this.agentAutoSelector);
            }
            return await this.agentAutoSelector.requestSelection();
        }
        catch (error) {
            this.logger.error(`Failed to select Pentest agent: ${error}`);
            return false;
        }
    }
    /**
     * Notifies VS Code that the custom agents have changed (for future use).
     */
    refresh() {
        this._onDidChangeCustomAgents.fire();
    }
    dispose() {
        this._onDidChangeCustomAgents.dispose();
        this.disposables.forEach(d => d.dispose());
    }
}
exports.PentestModeProvider = PentestModeProvider;
/**
 * Registers the Pentest mode provider with VS Code.
 * @param context Extension context
 * @param logger Logger for output
 * @returns The provider instance
 */
function registerPentestModeProvider(context, logger) {
    const provider = new PentestModeProvider(context.extensionUri, logger);
    provider.register();
    context.subscriptions.push(provider);
    return provider;
}


/***/ }),

/***/ "./src/extension.ts":
/*!**************************!*\
  !*** ./src/extension.ts ***!
  \**************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) BlackSwan. All rights reserved.
 *  Licensed under the MIT License.
 *--------------------------------------------------------------------------------------------*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.activate = activate;
exports.deactivate = deactivate;
exports.getInlineNoticeAPI = getInlineNoticeAPI;
const vscode = __importStar(__webpack_require__(/*! vscode */ "vscode"));
const fs_1 = __webpack_require__(/*! fs */ "fs");
const path_1 = __webpack_require__(/*! path */ "path");
const chat_1 = __webpack_require__(/*! ./chat */ "./src/chat/index.ts");
let authService;
let usageService;
// Project services
let projectManifestService;
let projectFolderScaffolder;
let projectModuleRegistry;
// Discovery service
let discoveryManager;
// Inline Notice System
let inlineNoticeSystem;
// Vulnerability Gutter Controller
let vulnerabilityGutterController;
async function activate(context) {
    // Create output channel for logging
    const outputChannel = vscode.window.createOutputChannel('BlackSwan', { log: true });
    context.subscriptions.push(outputChannel);
    outputChannel.info('Activating BlackSwan core extension');
    // Initialize Auth Service (lazy loaded to avoid blocking)
    const authModule = await Promise.resolve().then(() => __importStar(__webpack_require__(/*! ./auth */ "./src/auth/index.ts")));
    authService = new authModule.AuthService(context, outputChannel);
    context.subscriptions.push(authService);
    await authService.initialize();
    // Register VS Code Authentication Provider (Accounts menu)
    authModule.registerAuthenticationProvider(context, authService, outputChannel);
    // Status bar + commands
    const accountStatusBar = new authModule.AccountStatusBarManager(authService);
    context.subscriptions.push(accountStatusBar);
    const authCommands = new authModule.AuthCommandCenter(authService, null, outputChannel);
    authCommands.registerCommands(context);
    context.subscriptions.push(authCommands);
    // Initialize Usage Service
    usageService = new authModule.UsageService(context, authService, outputChannel);
    context.subscriptions.push(usageService);
    // Fetch initial usage data if logged in
    if (authService.isLoggedIn()) {
        void usageService.refreshUsageData();
    }
    // Account view (activity bar)
    const accountTreeProvider = new authModule.AccountTreeDataProvider(authService);
    accountTreeProvider.setUsageService(usageService);
    context.subscriptions.push(vscode.window.createTreeView('blackswan.account', {
        treeDataProvider: accountTreeProvider,
        showCollapseAll: false
    }));
    // Pentest agent mode
    (0, chat_1.registerPentestModeProvider)(context, outputChannel);
    // Initial context for menus/UX
    void vscode.commands.executeCommand('setContext', 'blackswan.auth.isLoggedIn', authService.isLoggedIn());
    // Webview commands (Account + Settings + Usage)
    context.subscriptions.push(vscode.commands.registerCommand('blackswan.openSettings', () => {
        vscode.commands.executeCommand('workbench.action.openSettings', '@ext:blackswan.blackswan');
    }), vscode.commands.registerCommand('blackswan.openAccount', () => {
        openWebviewPanel(context, authService, usageService, 'account', 'BlackSwan Account');
    }), vscode.commands.registerCommand('blackswan.openUsage', () => {
        openWebviewPanel(context, authService, usageService, 'usage', 'BlackSwan Usage');
    }));
}
function openWebviewPanel(context, authService, usageService, viewType, title) {
    const panel = vscode.window.createWebviewPanel(`blackswan-${viewType}`, title, vscode.ViewColumn.One, {
        enableScripts: true,
        retainContextWhenHidden: true,
        localResourceRoots: [
            vscode.Uri.joinPath(context.extensionUri, 'dist', 'webview'),
            context.extensionUri
        ]
    });
    // Listen for auth state changes
    const authDisposable = authService.onDidChangeAuthState((authState) => {
        panel.webview.postMessage({
            type: 'AUTH_STATE_CHANGED',
            payload: authState
        });
    });
    // Listen for usage data changes
    const usageDisposable = usageService.onDidChangeUsageData((usageData) => {
        panel.webview.postMessage({
            type: 'USAGE_UPDATE',
            payload: usageData
        });
    });
    // Dispose listeners when panel is closed
    panel.onDidDispose(() => {
        authDisposable.dispose();
        usageDisposable.dispose();
    });
    // Handle messages from the webview
    panel.webview.onDidReceiveMessage((message) => {
        const { command } = message;
        switch (command) {
            case 'GET_INIT_STATE':
                panel.webview.postMessage({
                    type: 'INIT_STATE',
                    payload: {
                        auth: authService.getAuthState(),
                        usage: usageService.getUsageData()
                    }
                });
                // Refresh usage data when webview opens
                if (authService.isLoggedIn()) {
                    void usageService.refreshUsageData();
                }
                break;
            case 'LOGIN':
                authService.login();
                break;
            case 'LOGOUT':
                authService.logout();
                break;
            case 'OPEN_SETTINGS':
                vscode.commands.executeCommand('blackswan.openSettings');
                break;
            case 'OPEN_BILLING':
                // Open the billing portal in the browser
                {
                    const authServerUrl = vscode.workspace.getConfiguration('blackswan.auth').get('serverUrl') || 'https://www.blackswan.sh';
                    vscode.env.openExternal(vscode.Uri.parse(`${authServerUrl}/dashboard?tab=billing`));
                }
                break;
            case 'REFRESH_USAGE':
                // Refresh usage data
                if (authService.isLoggedIn()) {
                    void usageService.refreshUsageData();
                }
                break;
            case 'START_CHECKOUT':
                // Open the checkout page in the browser
                {
                    const checkoutServerUrl = vscode.workspace.getConfiguration('blackswan.auth').get('serverUrl') || 'https://www.blackswan.sh';
                    vscode.env.openExternal(vscode.Uri.parse(`${checkoutServerUrl}/dashboard?tab=billing`));
                }
                break;
            case 'OPEN_ACCOUNT':
                // Open the account webview
                vscode.commands.executeCommand('blackswan.openAccount');
                break;
        }
    }, undefined, context.subscriptions);
    panel.webview.html = getWebviewHtml(context, panel.webview, viewType, title);
}
function getWebviewHtml(context, webview, viewType, title) {
    const isProduction = context.extensionMode === vscode.ExtensionMode.Production;
    const localServerUrl = 'http://localhost:9000';
    const localWsUrl = 'ws://localhost:9000';
    const scriptUrls = [];
    let cssUrl = null;
    const manifestPath = (0, path_1.join)(context.extensionPath, 'dist', 'webview', 'manifest.json');
    if (isProduction && (0, fs_1.existsSync)(manifestPath)) {
        const manifest = JSON.parse((0, fs_1.readFileSync)(manifestPath, 'utf-8'));
        for (const [key, value] of Object.entries(manifest)) {
            if (key.endsWith('.js')) {
                scriptUrls.push(webview.asWebviewUri(vscode.Uri.file((0, path_1.join)(context.extensionPath, 'dist', 'webview', value))).toString());
            }
            if (key.endsWith('.css')) {
                cssUrl = webview.asWebviewUri(vscode.Uri.file((0, path_1.join)(context.extensionPath, 'dist', 'webview', value))).toString();
            }
        }
    }
    else {
        scriptUrls.push(`${localServerUrl}/main.bundle.js`);
    }
    // Build CSP - include connect-src for dev server WebSocket (HMR)
    const cspParts = [
        `default-src 'none'`,
        `style-src ${webview.cspSource} 'unsafe-inline'`,
        `script-src ${webview.cspSource} 'unsafe-inline' ${localServerUrl}`,
        `font-src ${webview.cspSource}`,
        `img-src ${webview.cspSource} https: data:`,
        `connect-src ${localServerUrl} ${localWsUrl}`,
    ];
    return `<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Security-Policy" content="${cspParts.join('; ')}">
    ${cssUrl ? `<link href="${cssUrl}" rel="stylesheet">` : ''}
    <title>${title}</title>
</head>
<body>
    <div id="root" data-view="${viewType}"></div>
    ${scriptUrls.map((url) => `<script src="${url}"></script>`).join('\n')}
</body>
</html>`;
}
function deactivate() {
    // no-op
}
/**
 * Get the inline notice system API for publishing notices to editors.
 * @returns The inline notice API, or undefined if the extension is not activated
 */
function getInlineNoticeAPI() {
    return inlineNoticeSystem;
}


/***/ }),

/***/ "vscode":
/*!*************************!*\
  !*** external "vscode" ***!
  \*************************/
/***/ ((module) => {

module.exports = require("vscode");

/***/ }),

/***/ "fs":
/*!*********************!*\
  !*** external "fs" ***!
  \*********************/
/***/ ((module) => {

module.exports = require("fs");

/***/ }),

/***/ "path":
/*!***********************!*\
  !*** external "path" ***!
  \***********************/
/***/ ((module) => {

module.exports = require("path");

/***/ }),

/***/ "./node_modules/@better-auth/core/dist/env-8yWFh7b8.mjs":
/*!**************************************************************!*\
  !*** ./node_modules/@better-auth/core/dist/env-8yWFh7b8.mjs ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   a: () => (/* binding */ shouldPublishLog),
/* harmony export */   c: () => (/* binding */ env),
/* harmony export */   d: () => (/* binding */ isDevelopment),
/* harmony export */   f: () => (/* binding */ isProduction),
/* harmony export */   i: () => (/* binding */ logger),
/* harmony export */   l: () => (/* binding */ getBooleanEnvVar),
/* harmony export */   m: () => (/* binding */ nodeENV),
/* harmony export */   n: () => (/* binding */ createLogger),
/* harmony export */   o: () => (/* binding */ getColorDepth),
/* harmony export */   p: () => (/* binding */ isTest),
/* harmony export */   r: () => (/* binding */ levels),
/* harmony export */   s: () => (/* binding */ ENV),
/* harmony export */   t: () => (/* binding */ TTY_COLORS),
/* harmony export */   u: () => (/* binding */ getEnvVar)
/* harmony export */ });
//#region src/env/env-impl.ts
const _envShim = Object.create(null);
const _getEnv = (useShim) => globalThis.process?.env || globalThis.Deno?.env.toObject() || globalThis.__env__ || (useShim ? _envShim : globalThis);
const env = new Proxy(_envShim, {
	get(_, prop) {
		return _getEnv()[prop] ?? _envShim[prop];
	},
	has(_, prop) {
		return prop in _getEnv() || prop in _envShim;
	},
	set(_, prop, value) {
		const env$1 = _getEnv(true);
		env$1[prop] = value;
		return true;
	},
	deleteProperty(_, prop) {
		if (!prop) return false;
		const env$1 = _getEnv(true);
		delete env$1[prop];
		return true;
	},
	ownKeys() {
		const env$1 = _getEnv(true);
		return Object.keys(env$1);
	}
});
function toBoolean(val) {
	return val ? val !== "false" : false;
}
const nodeENV = typeof process !== "undefined" && process.env && "development" || "";
/** Detect if `NODE_ENV` environment variable is `production` */
const isProduction = nodeENV === "production";
/** Detect if `NODE_ENV` environment variable is `dev` or `development` */
const isDevelopment = () => nodeENV === "dev" || nodeENV === "development";
/** Detect if `NODE_ENV` environment variable is `test` */
const isTest = () => nodeENV === "test" || toBoolean(env.TEST);
/**
* Get environment variable with fallback
*/
function getEnvVar(key, fallback) {
	if (typeof process !== "undefined" && process.env) return process.env[key] ?? fallback;
	if (typeof Deno !== "undefined") return Deno.env.get(key) ?? fallback;
	if (typeof Bun !== "undefined") return Bun.env[key] ?? fallback;
	return fallback;
}
/**
* Get boolean environment variable
*/
function getBooleanEnvVar(key, fallback = true) {
	const value = getEnvVar(key);
	if (!value) return fallback;
	return value !== "0" && value.toLowerCase() !== "false" && value !== "";
}
/**
* Common environment variables used in Better Auth
*/
const ENV = Object.freeze({
	get BETTER_AUTH_SECRET() {
		return getEnvVar("BETTER_AUTH_SECRET");
	},
	get AUTH_SECRET() {
		return getEnvVar("AUTH_SECRET");
	},
	get BETTER_AUTH_TELEMETRY() {
		return getEnvVar("BETTER_AUTH_TELEMETRY");
	},
	get BETTER_AUTH_TELEMETRY_ID() {
		return getEnvVar("BETTER_AUTH_TELEMETRY_ID");
	},
	get NODE_ENV() {
		return getEnvVar("NODE_ENV", "development");
	},
	get PACKAGE_VERSION() {
		return getEnvVar("PACKAGE_VERSION", "0.0.0");
	},
	get BETTER_AUTH_TELEMETRY_ENDPOINT() {
		return getEnvVar("BETTER_AUTH_TELEMETRY_ENDPOINT", "https://telemetry.better-auth.com/v1/track");
	}
});

//#endregion
//#region src/env/color-depth.ts
const COLORS_2 = 1;
const COLORS_16 = 4;
const COLORS_256 = 8;
const COLORS_16m = 24;
const TERM_ENVS = {
	eterm: COLORS_16,
	cons25: COLORS_16,
	console: COLORS_16,
	cygwin: COLORS_16,
	dtterm: COLORS_16,
	gnome: COLORS_16,
	hurd: COLORS_16,
	jfbterm: COLORS_16,
	konsole: COLORS_16,
	kterm: COLORS_16,
	mlterm: COLORS_16,
	mosh: COLORS_16m,
	putty: COLORS_16,
	st: COLORS_16,
	"rxvt-unicode-24bit": COLORS_16m,
	terminator: COLORS_16m,
	"xterm-kitty": COLORS_16m
};
const CI_ENVS_MAP = new Map(Object.entries({
	APPVEYOR: COLORS_256,
	BUILDKITE: COLORS_256,
	CIRCLECI: COLORS_16m,
	DRONE: COLORS_256,
	GITEA_ACTIONS: COLORS_16m,
	GITHUB_ACTIONS: COLORS_16m,
	GITLAB_CI: COLORS_256,
	TRAVIS: COLORS_256
}));
const TERM_ENVS_REG_EXP = [
	/ansi/,
	/color/,
	/linux/,
	/direct/,
	/^con[0-9]*x[0-9]/,
	/^rxvt/,
	/^screen/,
	/^xterm/,
	/^vt100/,
	/^vt220/
];
function getColorDepth() {
	if (getEnvVar("FORCE_COLOR") !== void 0) switch (getEnvVar("FORCE_COLOR")) {
		case "":
		case "1":
		case "true": return COLORS_16;
		case "2": return COLORS_256;
		case "3": return COLORS_16m;
		default: return COLORS_2;
	}
	if (getEnvVar("NODE_DISABLE_COLORS") !== void 0 && getEnvVar("NODE_DISABLE_COLORS") !== "" || getEnvVar("NO_COLOR") !== void 0 && getEnvVar("NO_COLOR") !== "" || getEnvVar("TERM") === "dumb") return COLORS_2;
	if (getEnvVar("TMUX")) return COLORS_16m;
	if ("TF_BUILD" in env && "AGENT_NAME" in env) return COLORS_16;
	if ("CI" in env) {
		for (const { 0: envName, 1: colors } of CI_ENVS_MAP) if (envName in env) return colors;
		if (getEnvVar("CI_NAME") === "codeship") return COLORS_256;
		return COLORS_2;
	}
	if ("TEAMCITY_VERSION" in env) return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.exec(getEnvVar("TEAMCITY_VERSION")) !== null ? COLORS_16 : COLORS_2;
	switch (getEnvVar("TERM_PROGRAM")) {
		case "iTerm.app":
			if (!getEnvVar("TERM_PROGRAM_VERSION") || /^[0-2]\./.exec(getEnvVar("TERM_PROGRAM_VERSION")) !== null) return COLORS_256;
			return COLORS_16m;
		case "HyperTerm":
		case "MacTerm": return COLORS_16m;
		case "Apple_Terminal": return COLORS_256;
	}
	if (getEnvVar("COLORTERM") === "truecolor" || getEnvVar("COLORTERM") === "24bit") return COLORS_16m;
	if (getEnvVar("TERM")) {
		if (/truecolor/.exec(getEnvVar("TERM")) !== null) return COLORS_16m;
		if (/^xterm-256/.exec(getEnvVar("TERM")) !== null) return COLORS_256;
		const termEnv = getEnvVar("TERM").toLowerCase();
		if (TERM_ENVS[termEnv]) return TERM_ENVS[termEnv];
		if (TERM_ENVS_REG_EXP.some((term) => term.exec(termEnv) !== null)) return COLORS_16;
	}
	if (getEnvVar("COLORTERM")) return COLORS_16;
	return COLORS_2;
}

//#endregion
//#region src/env/logger.ts
const TTY_COLORS = {
	reset: "\x1B[0m",
	bright: "\x1B[1m",
	dim: "\x1B[2m",
	undim: "\x1B[22m",
	underscore: "\x1B[4m",
	blink: "\x1B[5m",
	reverse: "\x1B[7m",
	hidden: "\x1B[8m",
	fg: {
		black: "\x1B[30m",
		red: "\x1B[31m",
		green: "\x1B[32m",
		yellow: "\x1B[33m",
		blue: "\x1B[34m",
		magenta: "\x1B[35m",
		cyan: "\x1B[36m",
		white: "\x1B[37m"
	},
	bg: {
		black: "\x1B[40m",
		red: "\x1B[41m",
		green: "\x1B[42m",
		yellow: "\x1B[43m",
		blue: "\x1B[44m",
		magenta: "\x1B[45m",
		cyan: "\x1B[46m",
		white: "\x1B[47m"
	}
};
const levels = [
	"debug",
	"info",
	"success",
	"warn",
	"error"
];
function shouldPublishLog(currentLogLevel, logLevel) {
	return levels.indexOf(logLevel) >= levels.indexOf(currentLogLevel);
}
const levelColors = {
	info: TTY_COLORS.fg.blue,
	success: TTY_COLORS.fg.green,
	warn: TTY_COLORS.fg.yellow,
	error: TTY_COLORS.fg.red,
	debug: TTY_COLORS.fg.magenta
};
const formatMessage = (level, message, colorsEnabled) => {
	const timestamp = (/* @__PURE__ */ new Date()).toISOString();
	if (colorsEnabled) return `${TTY_COLORS.dim}${timestamp}${TTY_COLORS.reset} ${levelColors[level]}${level.toUpperCase()}${TTY_COLORS.reset} ${TTY_COLORS.bright}[Better Auth]:${TTY_COLORS.reset} ${message}`;
	return `${timestamp} ${level.toUpperCase()} [Better Auth]: ${message}`;
};
const createLogger = (options) => {
	const enabled = options?.disabled !== true;
	const logLevel = options?.level ?? "error";
	const colorsEnabled = options?.disableColors !== void 0 ? !options.disableColors : getColorDepth() !== 1;
	const LogFunc = (level, message, args = []) => {
		if (!enabled || !shouldPublishLog(logLevel, level)) return;
		const formattedMessage = formatMessage(level, message, colorsEnabled);
		if (!options || typeof options.log !== "function") {
			if (level === "error") console.error(formattedMessage, ...args);
			else if (level === "warn") console.warn(formattedMessage, ...args);
			else console.log(formattedMessage, ...args);
			return;
		}
		options.log(level === "success" ? "info" : level, message, ...args);
	};
	return {
		...Object.fromEntries(levels.map((level) => [level, (...[message, ...args]) => LogFunc(level, message, args)])),
		get level() {
			return logLevel;
		}
	};
};
const logger = createLogger();

//#endregion


/***/ }),

/***/ "./node_modules/@better-auth/core/dist/env/index.mjs":
/*!***********************************************************!*\
  !*** ./node_modules/@better-auth/core/dist/env/index.mjs ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ENV: () => (/* reexport safe */ _env_8yWFh7b8_mjs__WEBPACK_IMPORTED_MODULE_0__.s),
/* harmony export */   TTY_COLORS: () => (/* reexport safe */ _env_8yWFh7b8_mjs__WEBPACK_IMPORTED_MODULE_0__.t),
/* harmony export */   createLogger: () => (/* reexport safe */ _env_8yWFh7b8_mjs__WEBPACK_IMPORTED_MODULE_0__.n),
/* harmony export */   env: () => (/* reexport safe */ _env_8yWFh7b8_mjs__WEBPACK_IMPORTED_MODULE_0__.c),
/* harmony export */   getBooleanEnvVar: () => (/* reexport safe */ _env_8yWFh7b8_mjs__WEBPACK_IMPORTED_MODULE_0__.l),
/* harmony export */   getColorDepth: () => (/* reexport safe */ _env_8yWFh7b8_mjs__WEBPACK_IMPORTED_MODULE_0__.o),
/* harmony export */   getEnvVar: () => (/* reexport safe */ _env_8yWFh7b8_mjs__WEBPACK_IMPORTED_MODULE_0__.u),
/* harmony export */   isDevelopment: () => (/* reexport safe */ _env_8yWFh7b8_mjs__WEBPACK_IMPORTED_MODULE_0__.d),
/* harmony export */   isProduction: () => (/* reexport safe */ _env_8yWFh7b8_mjs__WEBPACK_IMPORTED_MODULE_0__.f),
/* harmony export */   isTest: () => (/* reexport safe */ _env_8yWFh7b8_mjs__WEBPACK_IMPORTED_MODULE_0__.p),
/* harmony export */   levels: () => (/* reexport safe */ _env_8yWFh7b8_mjs__WEBPACK_IMPORTED_MODULE_0__.r),
/* harmony export */   logger: () => (/* reexport safe */ _env_8yWFh7b8_mjs__WEBPACK_IMPORTED_MODULE_0__.i),
/* harmony export */   nodeENV: () => (/* reexport safe */ _env_8yWFh7b8_mjs__WEBPACK_IMPORTED_MODULE_0__.m),
/* harmony export */   shouldPublishLog: () => (/* reexport safe */ _env_8yWFh7b8_mjs__WEBPACK_IMPORTED_MODULE_0__.a)
/* harmony export */ });
/* harmony import */ var _env_8yWFh7b8_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../env-8yWFh7b8.mjs */ "./node_modules/@better-auth/core/dist/env-8yWFh7b8.mjs");




/***/ }),

/***/ "./node_modules/@better-auth/core/dist/error-BhAKg8LX.mjs":
/*!****************************************************************!*\
  !*** ./node_modules/@better-auth/core/dist/error-BhAKg8LX.mjs ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   n: () => (/* binding */ BASE_ERROR_CODES),
/* harmony export */   t: () => (/* binding */ BetterAuthError)
/* harmony export */ });
/* harmony import */ var _utils_C5EN75oV_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils-C5EN75oV.mjs */ "./node_modules/@better-auth/core/dist/utils-C5EN75oV.mjs");


//#region src/error/codes.ts
const BASE_ERROR_CODES = (0,_utils_C5EN75oV_mjs__WEBPACK_IMPORTED_MODULE_0__.t)({
	USER_NOT_FOUND: "User not found",
	FAILED_TO_CREATE_USER: "Failed to create user",
	FAILED_TO_CREATE_SESSION: "Failed to create session",
	FAILED_TO_UPDATE_USER: "Failed to update user",
	FAILED_TO_GET_SESSION: "Failed to get session",
	INVALID_PASSWORD: "Invalid password",
	INVALID_EMAIL: "Invalid email",
	INVALID_EMAIL_OR_PASSWORD: "Invalid email or password",
	SOCIAL_ACCOUNT_ALREADY_LINKED: "Social account already linked",
	PROVIDER_NOT_FOUND: "Provider not found",
	INVALID_TOKEN: "Invalid token",
	ID_TOKEN_NOT_SUPPORTED: "id_token not supported",
	FAILED_TO_GET_USER_INFO: "Failed to get user info",
	USER_EMAIL_NOT_FOUND: "User email not found",
	EMAIL_NOT_VERIFIED: "Email not verified",
	PASSWORD_TOO_SHORT: "Password too short",
	PASSWORD_TOO_LONG: "Password too long",
	USER_ALREADY_EXISTS: "User already exists.",
	USER_ALREADY_EXISTS_USE_ANOTHER_EMAIL: "User already exists. Use another email.",
	EMAIL_CAN_NOT_BE_UPDATED: "Email can not be updated",
	CREDENTIAL_ACCOUNT_NOT_FOUND: "Credential account not found",
	SESSION_EXPIRED: "Session expired. Re-authenticate to perform this action.",
	FAILED_TO_UNLINK_LAST_ACCOUNT: "You can't unlink your last account",
	ACCOUNT_NOT_FOUND: "Account not found",
	USER_ALREADY_HAS_PASSWORD: "User already has a password. Provide that to delete the account."
});

//#endregion
//#region src/error/index.ts
var BetterAuthError = class extends Error {
	constructor(message, cause) {
		super(message);
		this.name = "BetterAuthError";
		this.message = message;
		this.cause = cause;
		this.stack = "";
	}
};

//#endregion


/***/ }),

/***/ "./node_modules/@better-auth/core/dist/error/index.mjs":
/*!*************************************************************!*\
  !*** ./node_modules/@better-auth/core/dist/error/index.mjs ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BASE_ERROR_CODES: () => (/* reexport safe */ _error_BhAKg8LX_mjs__WEBPACK_IMPORTED_MODULE_1__.n),
/* harmony export */   BetterAuthError: () => (/* reexport safe */ _error_BhAKg8LX_mjs__WEBPACK_IMPORTED_MODULE_1__.t)
/* harmony export */ });
/* harmony import */ var _utils_C5EN75oV_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils-C5EN75oV.mjs */ "./node_modules/@better-auth/core/dist/utils-C5EN75oV.mjs");
/* harmony import */ var _error_BhAKg8LX_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../error-BhAKg8LX.mjs */ "./node_modules/@better-auth/core/dist/error-BhAKg8LX.mjs");





/***/ }),

/***/ "./node_modules/@better-auth/core/dist/utils-C5EN75oV.mjs":
/*!****************************************************************!*\
  !*** ./node_modules/@better-auth/core/dist/utils-C5EN75oV.mjs ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   t: () => (/* binding */ defineErrorCodes)
/* harmony export */ });
//#region src/utils/error-codes.ts
function defineErrorCodes(codes) {
	return codes;
}

//#endregion


/***/ }),

/***/ "./node_modules/@better-fetch/fetch/dist/index.js":
/*!********************************************************!*\
  !*** ./node_modules/@better-fetch/fetch/dist/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BetterFetchError: () => (/* binding */ BetterFetchError),
/* harmony export */   ValidationError: () => (/* binding */ ValidationError),
/* harmony export */   applySchemaPlugin: () => (/* binding */ applySchemaPlugin),
/* harmony export */   betterFetch: () => (/* binding */ betterFetch),
/* harmony export */   bodyParser: () => (/* binding */ bodyParser),
/* harmony export */   createFetch: () => (/* binding */ createFetch),
/* harmony export */   createRetryStrategy: () => (/* binding */ createRetryStrategy),
/* harmony export */   createSchema: () => (/* binding */ createSchema),
/* harmony export */   detectContentType: () => (/* binding */ detectContentType),
/* harmony export */   detectResponseType: () => (/* binding */ detectResponseType),
/* harmony export */   getBody: () => (/* binding */ getBody),
/* harmony export */   getFetch: () => (/* binding */ getFetch),
/* harmony export */   getHeaders: () => (/* binding */ getHeaders),
/* harmony export */   getMethod: () => (/* binding */ getMethod),
/* harmony export */   getTimeout: () => (/* binding */ getTimeout),
/* harmony export */   getURL: () => (/* binding */ getURL),
/* harmony export */   initializePlugins: () => (/* binding */ initializePlugins),
/* harmony export */   isFunction: () => (/* binding */ isFunction),
/* harmony export */   isJSONParsable: () => (/* binding */ isJSONParsable),
/* harmony export */   isJSONSerializable: () => (/* binding */ isJSONSerializable),
/* harmony export */   isPayloadMethod: () => (/* binding */ isPayloadMethod),
/* harmony export */   isRouteMethod: () => (/* binding */ isRouteMethod),
/* harmony export */   jsonParse: () => (/* binding */ jsonParse),
/* harmony export */   methods: () => (/* binding */ methods),
/* harmony export */   parseStandardSchema: () => (/* binding */ parseStandardSchema)
/* harmony export */ });
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));

// src/error.ts
var BetterFetchError = class extends Error {
  constructor(status, statusText, error) {
    super(statusText || status.toString(), {
      cause: error
    });
    this.status = status;
    this.statusText = statusText;
    this.error = error;
  }
};

// src/plugins.ts
var initializePlugins = async (url, options) => {
  var _a, _b, _c, _d, _e, _f;
  let opts = options || {};
  const hooks = {
    onRequest: [options == null ? void 0 : options.onRequest],
    onResponse: [options == null ? void 0 : options.onResponse],
    onSuccess: [options == null ? void 0 : options.onSuccess],
    onError: [options == null ? void 0 : options.onError],
    onRetry: [options == null ? void 0 : options.onRetry]
  };
  if (!options || !(options == null ? void 0 : options.plugins)) {
    return {
      url,
      options: opts,
      hooks
    };
  }
  for (const plugin of (options == null ? void 0 : options.plugins) || []) {
    if (plugin.init) {
      const pluginRes = await ((_a = plugin.init) == null ? void 0 : _a.call(plugin, url.toString(), options));
      opts = pluginRes.options || opts;
      url = pluginRes.url;
    }
    hooks.onRequest.push((_b = plugin.hooks) == null ? void 0 : _b.onRequest);
    hooks.onResponse.push((_c = plugin.hooks) == null ? void 0 : _c.onResponse);
    hooks.onSuccess.push((_d = plugin.hooks) == null ? void 0 : _d.onSuccess);
    hooks.onError.push((_e = plugin.hooks) == null ? void 0 : _e.onError);
    hooks.onRetry.push((_f = plugin.hooks) == null ? void 0 : _f.onRetry);
  }
  return {
    url,
    options: opts,
    hooks
  };
};

// src/retry.ts
var LinearRetryStrategy = class {
  constructor(options) {
    this.options = options;
  }
  shouldAttemptRetry(attempt, response) {
    if (this.options.shouldRetry) {
      return Promise.resolve(
        attempt < this.options.attempts && this.options.shouldRetry(response)
      );
    }
    return Promise.resolve(attempt < this.options.attempts);
  }
  getDelay() {
    return this.options.delay;
  }
};
var ExponentialRetryStrategy = class {
  constructor(options) {
    this.options = options;
  }
  shouldAttemptRetry(attempt, response) {
    if (this.options.shouldRetry) {
      return Promise.resolve(
        attempt < this.options.attempts && this.options.shouldRetry(response)
      );
    }
    return Promise.resolve(attempt < this.options.attempts);
  }
  getDelay(attempt) {
    const delay = Math.min(
      this.options.maxDelay,
      this.options.baseDelay * 2 ** attempt
    );
    return delay;
  }
};
function createRetryStrategy(options) {
  if (typeof options === "number") {
    return new LinearRetryStrategy({
      type: "linear",
      attempts: options,
      delay: 1e3
    });
  }
  switch (options.type) {
    case "linear":
      return new LinearRetryStrategy(options);
    case "exponential":
      return new ExponentialRetryStrategy(options);
    default:
      throw new Error("Invalid retry strategy");
  }
}

// src/auth.ts
var getAuthHeader = async (options) => {
  const headers = {};
  const getValue = async (value) => typeof value === "function" ? await value() : value;
  if (options == null ? void 0 : options.auth) {
    if (options.auth.type === "Bearer") {
      const token = await getValue(options.auth.token);
      if (!token) {
        return headers;
      }
      headers["authorization"] = `Bearer ${token}`;
    } else if (options.auth.type === "Basic") {
      const username = getValue(options.auth.username);
      const password = getValue(options.auth.password);
      if (!username || !password) {
        return headers;
      }
      headers["authorization"] = `Basic ${btoa(`${username}:${password}`)}`;
    } else if (options.auth.type === "Custom") {
      const value = getValue(options.auth.value);
      if (!value) {
        return headers;
      }
      headers["authorization"] = `${getValue(options.auth.prefix)} ${value}`;
    }
  }
  return headers;
};

// src/utils.ts
var JSON_RE = /^application\/(?:[\w!#$%&*.^`~-]*\+)?json(;.+)?$/i;
function detectResponseType(request) {
  const _contentType = request.headers.get("content-type");
  const textTypes = /* @__PURE__ */ new Set([
    "image/svg",
    "application/xml",
    "application/xhtml",
    "application/html"
  ]);
  if (!_contentType) {
    return "json";
  }
  const contentType = _contentType.split(";").shift() || "";
  if (JSON_RE.test(contentType)) {
    return "json";
  }
  if (textTypes.has(contentType) || contentType.startsWith("text/")) {
    return "text";
  }
  return "blob";
}
function isJSONParsable(value) {
  try {
    JSON.parse(value);
    return true;
  } catch (error) {
    return false;
  }
}
function isJSONSerializable(value) {
  if (value === void 0) {
    return false;
  }
  const t = typeof value;
  if (t === "string" || t === "number" || t === "boolean" || t === null) {
    return true;
  }
  if (t !== "object") {
    return false;
  }
  if (Array.isArray(value)) {
    return true;
  }
  if (value.buffer) {
    return false;
  }
  return value.constructor && value.constructor.name === "Object" || typeof value.toJSON === "function";
}
function jsonParse(text) {
  try {
    return JSON.parse(text);
  } catch (error) {
    return text;
  }
}
function isFunction(value) {
  return typeof value === "function";
}
function getFetch(options) {
  if (options == null ? void 0 : options.customFetchImpl) {
    return options.customFetchImpl;
  }
  if (typeof globalThis !== "undefined" && isFunction(globalThis.fetch)) {
    return globalThis.fetch;
  }
  if (typeof window !== "undefined" && isFunction(window.fetch)) {
    return window.fetch;
  }
  throw new Error("No fetch implementation found");
}
function isPayloadMethod(method) {
  if (!method) {
    return false;
  }
  const payloadMethod = ["POST", "PUT", "PATCH", "DELETE"];
  return payloadMethod.includes(method.toUpperCase());
}
function isRouteMethod(method) {
  const routeMethod = ["GET", "POST", "PUT", "PATCH", "DELETE"];
  if (!method) {
    return false;
  }
  return routeMethod.includes(method.toUpperCase());
}
async function getHeaders(opts) {
  const headers = new Headers(opts == null ? void 0 : opts.headers);
  const authHeader = await getAuthHeader(opts);
  for (const [key, value] of Object.entries(authHeader || {})) {
    headers.set(key, value);
  }
  if (!headers.has("content-type")) {
    const t = detectContentType(opts == null ? void 0 : opts.body);
    if (t) {
      headers.set("content-type", t);
    }
  }
  return headers;
}
function getURL(url, options) {
  if (url.startsWith("@")) {
    const m = url.toString().split("@")[1].split("/")[0];
    if (methods.includes(m)) {
      url = url.replace(`@${m}/`, "/");
    }
  }
  let _url;
  try {
    if (url.startsWith("http")) {
      _url = url;
    } else {
      let baseURL = options == null ? void 0 : options.baseURL;
      if (baseURL && !(baseURL == null ? void 0 : baseURL.endsWith("/"))) {
        baseURL = baseURL + "/";
      }
      if (url.startsWith("/")) {
        _url = new URL(url.substring(1), baseURL);
      } else {
        _url = new URL(url, options == null ? void 0 : options.baseURL);
      }
    }
  } catch (e) {
    if (e instanceof TypeError) {
      if (!(options == null ? void 0 : options.baseURL)) {
        throw TypeError(
          `Invalid URL ${url}. Are you passing in a relative url but not setting the baseURL?`
        );
      }
      throw TypeError(
        `Invalid URL ${url}. Please validate that you are passing the correct input.`
      );
    }
    throw e;
  }
  if (options == null ? void 0 : options.params) {
    if (Array.isArray(options == null ? void 0 : options.params)) {
      const params = (options == null ? void 0 : options.params) ? Array.isArray(options.params) ? `/${options.params.join("/")}` : `/${Object.values(options.params).join("/")}` : "";
      _url = _url.toString().split("/:")[0];
      _url = `${_url.toString()}${params}`;
    } else {
      for (const [key, value] of Object.entries(options == null ? void 0 : options.params)) {
        _url = _url.toString().replace(`:${key}`, String(value));
      }
    }
  }
  const __url = new URL(_url);
  const queryParams = options == null ? void 0 : options.query;
  if (queryParams) {
    for (const [key, value] of Object.entries(queryParams)) {
      __url.searchParams.append(key, String(value));
    }
  }
  return __url;
}
function detectContentType(body) {
  if (isJSONSerializable(body)) {
    return "application/json";
  }
  return null;
}
function getBody(options) {
  if (!(options == null ? void 0 : options.body)) {
    return null;
  }
  const headers = new Headers(options == null ? void 0 : options.headers);
  if (isJSONSerializable(options.body) && !headers.has("content-type")) {
    for (const [key, value] of Object.entries(options == null ? void 0 : options.body)) {
      if (value instanceof Date) {
        options.body[key] = value.toISOString();
      }
    }
    return JSON.stringify(options.body);
  }
  return options.body;
}
function getMethod(url, options) {
  var _a;
  if (options == null ? void 0 : options.method) {
    return options.method.toUpperCase();
  }
  if (url.startsWith("@")) {
    const pMethod = (_a = url.split("@")[1]) == null ? void 0 : _a.split("/")[0];
    if (!methods.includes(pMethod)) {
      return (options == null ? void 0 : options.body) ? "POST" : "GET";
    }
    return pMethod.toUpperCase();
  }
  return (options == null ? void 0 : options.body) ? "POST" : "GET";
}
function getTimeout(options, controller) {
  let abortTimeout;
  if (!(options == null ? void 0 : options.signal) && (options == null ? void 0 : options.timeout)) {
    abortTimeout = setTimeout(() => controller == null ? void 0 : controller.abort(), options == null ? void 0 : options.timeout);
  }
  return {
    abortTimeout,
    clearTimeout: () => {
      if (abortTimeout) {
        clearTimeout(abortTimeout);
      }
    }
  };
}
function bodyParser(data, responseType) {
  if (responseType === "json") {
    return JSON.parse(data);
  }
  return data;
}
var ValidationError = class _ValidationError extends Error {
  constructor(issues, message) {
    super(message || JSON.stringify(issues, null, 2));
    this.issues = issues;
    Object.setPrototypeOf(this, _ValidationError.prototype);
  }
};
async function parseStandardSchema(schema, input) {
  let result = await schema["~standard"].validate(input);
  if (result.issues) {
    throw new ValidationError(result.issues);
  }
  return result.value;
}

// src/create-fetch/schema.ts
var methods = ["get", "post", "put", "patch", "delete"];
var createSchema = (schema, config) => {
  return {
    schema,
    config
  };
};

// src/create-fetch/index.ts
var applySchemaPlugin = (config) => ({
  id: "apply-schema",
  name: "Apply Schema",
  version: "1.0.0",
  async init(url, options) {
    var _a, _b, _c, _d;
    const schema = ((_b = (_a = config.plugins) == null ? void 0 : _a.find(
      (plugin) => {
        var _a2;
        return ((_a2 = plugin.schema) == null ? void 0 : _a2.config) ? url.startsWith(plugin.schema.config.baseURL || "") || url.startsWith(plugin.schema.config.prefix || "") : false;
      }
    )) == null ? void 0 : _b.schema) || config.schema;
    if (schema) {
      let urlKey = url;
      if ((_c = schema.config) == null ? void 0 : _c.prefix) {
        if (urlKey.startsWith(schema.config.prefix)) {
          urlKey = urlKey.replace(schema.config.prefix, "");
          if (schema.config.baseURL) {
            url = url.replace(schema.config.prefix, schema.config.baseURL);
          }
        }
      }
      if ((_d = schema.config) == null ? void 0 : _d.baseURL) {
        if (urlKey.startsWith(schema.config.baseURL)) {
          urlKey = urlKey.replace(schema.config.baseURL, "");
        }
      }
      const keySchema = schema.schema[urlKey];
      if (keySchema) {
        let opts = __spreadProps(__spreadValues({}, options), {
          method: keySchema.method,
          output: keySchema.output
        });
        if (!(options == null ? void 0 : options.disableValidation)) {
          opts = __spreadProps(__spreadValues({}, opts), {
            body: keySchema.input ? await parseStandardSchema(keySchema.input, options == null ? void 0 : options.body) : options == null ? void 0 : options.body,
            params: keySchema.params ? await parseStandardSchema(keySchema.params, options == null ? void 0 : options.params) : options == null ? void 0 : options.params,
            query: keySchema.query ? await parseStandardSchema(keySchema.query, options == null ? void 0 : options.query) : options == null ? void 0 : options.query
          });
        }
        return {
          url,
          options: opts
        };
      }
    }
    return {
      url,
      options
    };
  }
});
var createFetch = (config) => {
  async function $fetch(url, options) {
    const opts = __spreadProps(__spreadValues(__spreadValues({}, config), options), {
      plugins: [...(config == null ? void 0 : config.plugins) || [], applySchemaPlugin(config || {})]
    });
    if (config == null ? void 0 : config.catchAllError) {
      try {
        return await betterFetch(url, opts);
      } catch (error) {
        return {
          data: null,
          error: {
            status: 500,
            statusText: "Fetch Error",
            message: "Fetch related error. Captured by catchAllError option. See error property for more details.",
            error
          }
        };
      }
    }
    return await betterFetch(url, opts);
  }
  return $fetch;
};

// src/url.ts
function getURL2(url, option) {
  let { baseURL, params, query } = option || {
    query: {},
    params: {},
    baseURL: ""
  };
  let basePath = url.startsWith("http") ? url.split("/").slice(0, 3).join("/") : baseURL || "";
  if (url.startsWith("@")) {
    const m = url.toString().split("@")[1].split("/")[0];
    if (methods.includes(m)) {
      url = url.replace(`@${m}/`, "/");
    }
  }
  if (!basePath.endsWith("/")) basePath += "/";
  let [path, urlQuery] = url.replace(basePath, "").split("?");
  const queryParams = new URLSearchParams(urlQuery);
  for (const [key, value] of Object.entries(query || {})) {
    if (value == null) continue;
    queryParams.set(key, String(value));
  }
  if (params) {
    if (Array.isArray(params)) {
      const paramPaths = path.split("/").filter((p) => p.startsWith(":"));
      for (const [index, key] of paramPaths.entries()) {
        const value = params[index];
        path = path.replace(key, value);
      }
    } else {
      for (const [key, value] of Object.entries(params)) {
        path = path.replace(`:${key}`, String(value));
      }
    }
  }
  path = path.split("/").map(encodeURIComponent).join("/");
  if (path.startsWith("/")) path = path.slice(1);
  let queryParamString = queryParams.toString();
  queryParamString = queryParamString.length > 0 ? `?${queryParamString}`.replace(/\+/g, "%20") : "";
  if (!basePath.startsWith("http")) {
    return `${basePath}${path}${queryParamString}`;
  }
  const _url = new URL(`${path}${queryParamString}`, basePath);
  return _url;
}

// src/fetch.ts
var betterFetch = async (url, options) => {
  var _a, _b, _c, _d, _e, _f, _g, _h;
  const {
    hooks,
    url: __url,
    options: opts
  } = await initializePlugins(url, options);
  const fetch = getFetch(opts);
  const controller = new AbortController();
  const signal = (_a = opts.signal) != null ? _a : controller.signal;
  const _url = getURL2(__url, opts);
  const body = getBody(opts);
  const headers = await getHeaders(opts);
  const method = getMethod(__url, opts);
  let context = __spreadProps(__spreadValues({}, opts), {
    url: _url,
    headers,
    body,
    method,
    signal
  });
  for (const onRequest of hooks.onRequest) {
    if (onRequest) {
      const res = await onRequest(context);
      if (res instanceof Object) {
        context = res;
      }
    }
  }
  if ("pipeTo" in context && typeof context.pipeTo === "function" || typeof ((_b = options == null ? void 0 : options.body) == null ? void 0 : _b.pipe) === "function") {
    if (!("duplex" in context)) {
      context.duplex = "half";
    }
  }
  const { clearTimeout: clearTimeout2 } = getTimeout(opts, controller);
  let response = await fetch(context.url, context);
  clearTimeout2();
  const responseContext = {
    response,
    request: context
  };
  for (const onResponse of hooks.onResponse) {
    if (onResponse) {
      const r = await onResponse(__spreadProps(__spreadValues({}, responseContext), {
        response: ((_c = options == null ? void 0 : options.hookOptions) == null ? void 0 : _c.cloneResponse) ? response.clone() : response
      }));
      if (r instanceof Response) {
        response = r;
      } else if (r instanceof Object) {
        response = r.response;
      }
    }
  }
  if (response.ok) {
    const hasBody = context.method !== "HEAD";
    if (!hasBody) {
      return {
        data: "",
        error: null
      };
    }
    const responseType = detectResponseType(response);
    const successContext = {
      data: "",
      response,
      request: context
    };
    if (responseType === "json" || responseType === "text") {
      const text = await response.text();
      const parser2 = (_d = context.jsonParser) != null ? _d : jsonParse;
      const data = await parser2(text);
      successContext.data = data;
    } else {
      successContext.data = await response[responseType]();
    }
    if (context == null ? void 0 : context.output) {
      if (context.output && !context.disableValidation) {
        successContext.data = await parseStandardSchema(
          context.output,
          successContext.data
        );
      }
    }
    for (const onSuccess of hooks.onSuccess) {
      if (onSuccess) {
        await onSuccess(__spreadProps(__spreadValues({}, successContext), {
          response: ((_e = options == null ? void 0 : options.hookOptions) == null ? void 0 : _e.cloneResponse) ? response.clone() : response
        }));
      }
    }
    if (options == null ? void 0 : options.throw) {
      return successContext.data;
    }
    return {
      data: successContext.data,
      error: null
    };
  }
  const parser = (_f = options == null ? void 0 : options.jsonParser) != null ? _f : jsonParse;
  const responseText = await response.text();
  const isJSONResponse = isJSONParsable(responseText);
  const errorObject = isJSONResponse ? await parser(responseText) : null;
  const errorContext = {
    response,
    responseText,
    request: context,
    error: __spreadProps(__spreadValues({}, errorObject), {
      status: response.status,
      statusText: response.statusText
    })
  };
  for (const onError of hooks.onError) {
    if (onError) {
      await onError(__spreadProps(__spreadValues({}, errorContext), {
        response: ((_g = options == null ? void 0 : options.hookOptions) == null ? void 0 : _g.cloneResponse) ? response.clone() : response
      }));
    }
  }
  if (options == null ? void 0 : options.retry) {
    const retryStrategy = createRetryStrategy(options.retry);
    const _retryAttempt = (_h = options.retryAttempt) != null ? _h : 0;
    if (await retryStrategy.shouldAttemptRetry(_retryAttempt, response)) {
      for (const onRetry of hooks.onRetry) {
        if (onRetry) {
          await onRetry(responseContext);
        }
      }
      const delay = retryStrategy.getDelay(_retryAttempt);
      await new Promise((resolve) => setTimeout(resolve, delay));
      return await betterFetch(url, __spreadProps(__spreadValues({}, options), {
        retryAttempt: _retryAttempt + 1
      }));
    }
  }
  if (options == null ? void 0 : options.throw) {
    throw new BetterFetchError(
      response.status,
      response.statusText,
      isJSONResponse ? errorObject : responseText
    );
  }
  return {
    data: null,
    error: __spreadProps(__spreadValues({}, errorObject), {
      status: response.status,
      statusText: response.statusText
    })
  };
};

//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/better-auth/dist/access-Dx8TLKnw.mjs":
/*!***********************************************************!*\
  !*** ./node_modules/better-auth/dist/access-Dx8TLKnw.mjs ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   n: () => (/* binding */ role),
/* harmony export */   t: () => (/* binding */ createAccessControl)
/* harmony export */ });
/* harmony import */ var _better_auth_core_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @better-auth/core/error */ "./node_modules/@better-auth/core/dist/error/index.mjs");


//#region src/plugins/access/access.ts
function role(statements) {
	return {
		authorize(request, connector = "AND") {
			let success = false;
			for (const [requestedResource, requestedActions] of Object.entries(request)) {
				const allowedActions = statements[requestedResource];
				if (!allowedActions) return {
					success: false,
					error: `You are not allowed to access resource: ${requestedResource}`
				};
				if (Array.isArray(requestedActions)) success = requestedActions.every((requestedAction) => allowedActions.includes(requestedAction));
				else if (typeof requestedActions === "object") {
					const actions = requestedActions;
					if (actions.connector === "OR") success = actions.actions.some((requestedAction) => allowedActions.includes(requestedAction));
					else success = actions.actions.every((requestedAction) => allowedActions.includes(requestedAction));
				} else throw new _better_auth_core_error__WEBPACK_IMPORTED_MODULE_0__.BetterAuthError("Invalid access control request");
				if (success && connector === "OR") return { success };
				if (!success && connector === "AND") return {
					success: false,
					error: `unauthorized to access resource "${requestedResource}"`
				};
			}
			if (success) return { success };
			return {
				success: false,
				error: "Not authorized"
			};
		},
		statements
	};
}
function createAccessControl(s) {
	return {
		newRole(statements) {
			return role(statements);
		},
		statements: s
	};
}

//#endregion


/***/ }),

/***/ "./node_modules/better-auth/dist/access-h-uttVNZ.mjs":
/*!***********************************************************!*\
  !*** ./node_modules/better-auth/dist/access-h-uttVNZ.mjs ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   a: () => (/* binding */ userAc),
/* harmony export */   i: () => (/* binding */ defaultStatements),
/* harmony export */   n: () => (/* binding */ defaultAc),
/* harmony export */   r: () => (/* binding */ defaultRoles),
/* harmony export */   t: () => (/* binding */ adminAc)
/* harmony export */ });
/* harmony import */ var _access_Dx8TLKnw_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./access-Dx8TLKnw.mjs */ "./node_modules/better-auth/dist/access-Dx8TLKnw.mjs");


//#region src/plugins/admin/access/statement.ts
const defaultStatements = {
	user: [
		"create",
		"list",
		"set-role",
		"ban",
		"impersonate",
		"delete",
		"set-password",
		"get",
		"update"
	],
	session: [
		"list",
		"revoke",
		"delete"
	]
};
const defaultAc = (0,_access_Dx8TLKnw_mjs__WEBPACK_IMPORTED_MODULE_0__.t)(defaultStatements);
const adminAc = defaultAc.newRole({
	user: [
		"create",
		"list",
		"set-role",
		"ban",
		"impersonate",
		"delete",
		"set-password",
		"get",
		"update"
	],
	session: [
		"list",
		"revoke",
		"delete"
	]
});
const userAc = defaultAc.newRole({
	user: [],
	session: []
});
const defaultRoles = {
	admin: adminAc,
	user: userAc
};

//#endregion


/***/ }),

/***/ "./node_modules/better-auth/dist/access-vPNO48H4.mjs":
/*!***********************************************************!*\
  !*** ./node_modules/better-auth/dist/access-vPNO48H4.mjs ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   a: () => (/* binding */ memberAc),
/* harmony export */   i: () => (/* binding */ defaultStatements),
/* harmony export */   n: () => (/* binding */ defaultAc),
/* harmony export */   o: () => (/* binding */ ownerAc),
/* harmony export */   r: () => (/* binding */ defaultRoles),
/* harmony export */   t: () => (/* binding */ adminAc)
/* harmony export */ });
/* harmony import */ var _access_Dx8TLKnw_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./access-Dx8TLKnw.mjs */ "./node_modules/better-auth/dist/access-Dx8TLKnw.mjs");


//#region src/plugins/organization/access/statement.ts
const defaultStatements = {
	organization: ["update", "delete"],
	member: [
		"create",
		"update",
		"delete"
	],
	invitation: ["create", "cancel"],
	team: [
		"create",
		"update",
		"delete"
	],
	ac: [
		"create",
		"read",
		"update",
		"delete"
	]
};
const defaultAc = (0,_access_Dx8TLKnw_mjs__WEBPACK_IMPORTED_MODULE_0__.t)(defaultStatements);
const adminAc = defaultAc.newRole({
	organization: ["update"],
	invitation: ["create", "cancel"],
	member: [
		"create",
		"update",
		"delete"
	],
	team: [
		"create",
		"update",
		"delete"
	],
	ac: [
		"create",
		"read",
		"update",
		"delete"
	]
});
const ownerAc = defaultAc.newRole({
	organization: ["update", "delete"],
	member: [
		"create",
		"update",
		"delete"
	],
	invitation: ["create", "cancel"],
	team: [
		"create",
		"update",
		"delete"
	],
	ac: [
		"create",
		"read",
		"update",
		"delete"
	]
});
const memberAc = defaultAc.newRole({
	organization: [],
	member: [],
	invitation: [],
	team: [],
	ac: ["read"]
});
const defaultRoles = {
	admin: adminAc,
	owner: ownerAc,
	member: memberAc
};

//#endregion


/***/ }),

/***/ "./node_modules/better-auth/dist/client-BN9e9KX1.mjs":
/*!***********************************************************!*\
  !*** ./node_modules/better-auth/dist/client-BN9e9KX1.mjs ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   n: () => (/* binding */ InferPlugin),
/* harmony export */   r: () => (/* binding */ createAuthClient),
/* harmony export */   t: () => (/* binding */ InferAuth)
/* harmony export */ });
/* harmony import */ var _misc_BwNc0MKr_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./misc-BwNc0MKr.mjs */ "./node_modules/better-auth/dist/misc-BwNc0MKr.mjs");
/* harmony import */ var _proxy_DplNCOES_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./proxy-DplNCOES.mjs */ "./node_modules/better-auth/dist/proxy-DplNCOES.mjs");



//#region src/client/vanilla.ts
function createAuthClient(options) {
	const { pluginPathMethods, pluginsActions, pluginsAtoms, $fetch, atomListeners, $store } = (0,_proxy_DplNCOES_mjs__WEBPACK_IMPORTED_MODULE_1__.n)(options);
	let resolvedHooks = {};
	for (const [key, value] of Object.entries(pluginsAtoms)) resolvedHooks[`use${(0,_misc_BwNc0MKr_mjs__WEBPACK_IMPORTED_MODULE_0__.t)(key)}`] = value;
	return (0,_proxy_DplNCOES_mjs__WEBPACK_IMPORTED_MODULE_1__.t)({
		...pluginsActions,
		...resolvedHooks,
		$fetch,
		$store
	}, $fetch, pluginPathMethods, pluginsAtoms, atomListeners);
}

//#endregion
//#region src/client/index.ts
const InferPlugin = () => {
	return {
		id: "infer-server-plugin",
		$InferServerPlugin: {}
	};
};
function InferAuth() {
	return {};
}

//#endregion


/***/ }),

/***/ "./node_modules/better-auth/dist/client-CMPEe5-e.mjs":
/*!***********************************************************!*\
  !*** ./node_modules/better-auth/dist/client-CMPEe5-e.mjs ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   t: () => (/* binding */ twoFactorClient)
/* harmony export */ });
//#region src/plugins/two-factor/client.ts
const twoFactorClient = (options) => {
	return {
		id: "two-factor",
		$InferServerPlugin: {},
		atomListeners: [{
			matcher: (path) => path.startsWith("/two-factor/"),
			signal: "$sessionSignal"
		}],
		pathMethods: {
			"/two-factor/disable": "POST",
			"/two-factor/enable": "POST",
			"/two-factor/send-otp": "POST",
			"/two-factor/generate-backup-codes": "POST"
		},
		fetchPlugins: [{
			id: "two-factor",
			name: "two-factor",
			hooks: { async onSuccess(context) {
				if (context.data?.twoFactorRedirect) {
					if (options?.onTwoFactorRedirect) await options.onTwoFactorRedirect();
				}
			} }
		}]
	};
};

//#endregion


/***/ }),

/***/ "./node_modules/better-auth/dist/client/index.mjs":
/*!********************************************************!*\
  !*** ./node_modules/better-auth/dist/client/index.mjs ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InferAuth: () => (/* reexport safe */ _client_BN9e9KX1_mjs__WEBPACK_IMPORTED_MODULE_4__.t),
/* harmony export */   InferPlugin: () => (/* reexport safe */ _client_BN9e9KX1_mjs__WEBPACK_IMPORTED_MODULE_4__.n),
/* harmony export */   createAuthClient: () => (/* reexport safe */ _client_BN9e9KX1_mjs__WEBPACK_IMPORTED_MODULE_4__.r),
/* harmony export */   createSessionRefreshManager: () => (/* reexport safe */ _proxy_DplNCOES_mjs__WEBPACK_IMPORTED_MODULE_2__.r),
/* harmony export */   getGlobalBroadcastChannel: () => (/* reexport safe */ _proxy_DplNCOES_mjs__WEBPACK_IMPORTED_MODULE_2__.s),
/* harmony export */   kBroadcastChannel: () => (/* reexport safe */ _proxy_DplNCOES_mjs__WEBPACK_IMPORTED_MODULE_2__.c),
/* harmony export */   kFocusManager: () => (/* reexport safe */ _proxy_DplNCOES_mjs__WEBPACK_IMPORTED_MODULE_2__.o),
/* harmony export */   kOnlineManager: () => (/* reexport safe */ _proxy_DplNCOES_mjs__WEBPACK_IMPORTED_MODULE_2__.a),
/* harmony export */   useAuthQuery: () => (/* reexport safe */ _proxy_DplNCOES_mjs__WEBPACK_IMPORTED_MODULE_2__.i)
/* harmony export */ });
/* harmony import */ var _misc_BwNc0MKr_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../misc-BwNc0MKr.mjs */ "./node_modules/better-auth/dist/misc-BwNc0MKr.mjs");
/* harmony import */ var _url_CB8xCwz_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../url-CB8xCwz-.mjs */ "./node_modules/better-auth/dist/url-CB8xCwz-.mjs");
/* harmony import */ var _proxy_DplNCOES_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../proxy-DplNCOES.mjs */ "./node_modules/better-auth/dist/proxy-DplNCOES.mjs");
/* harmony import */ var _parser_pHp5yoAv_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../parser-pHp5yoAv.mjs */ "./node_modules/better-auth/dist/parser-pHp5yoAv.mjs");
/* harmony import */ var _client_BN9e9KX1_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../client-BN9e9KX1.mjs */ "./node_modules/better-auth/dist/client-BN9e9KX1.mjs");








/***/ }),

/***/ "./node_modules/better-auth/dist/client/plugins/index.mjs":
/*!****************************************************************!*\
  !*** ./node_modules/better-auth/dist/client/plugins/index.mjs ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InferServerPlugin: () => (/* binding */ InferServerPlugin),
/* harmony export */   adminClient: () => (/* binding */ adminClient),
/* harmony export */   anonymousClient: () => (/* binding */ anonymousClient),
/* harmony export */   apiKeyClient: () => (/* binding */ apiKeyClient),
/* harmony export */   clientSideHasPermission: () => (/* binding */ clientSideHasPermission),
/* harmony export */   customSessionClient: () => (/* binding */ customSessionClient),
/* harmony export */   deviceAuthorizationClient: () => (/* binding */ deviceAuthorizationClient),
/* harmony export */   emailOTPClient: () => (/* binding */ emailOTPClient),
/* harmony export */   genericOAuthClient: () => (/* binding */ genericOAuthClient),
/* harmony export */   inferAdditionalFields: () => (/* binding */ inferAdditionalFields),
/* harmony export */   inferOrgAdditionalFields: () => (/* binding */ inferOrgAdditionalFields),
/* harmony export */   jwtClient: () => (/* binding */ jwtClient),
/* harmony export */   lastLoginMethodClient: () => (/* binding */ lastLoginMethodClient),
/* harmony export */   magicLinkClient: () => (/* binding */ magicLinkClient),
/* harmony export */   multiSessionClient: () => (/* binding */ multiSessionClient),
/* harmony export */   oidcClient: () => (/* binding */ oidcClient),
/* harmony export */   oneTapClient: () => (/* binding */ oneTapClient),
/* harmony export */   oneTimeTokenClient: () => (/* binding */ oneTimeTokenClient),
/* harmony export */   organizationClient: () => (/* binding */ organizationClient),
/* harmony export */   phoneNumberClient: () => (/* binding */ phoneNumberClient),
/* harmony export */   siweClient: () => (/* binding */ siweClient),
/* harmony export */   twoFactorClient: () => (/* reexport safe */ _client_CMPEe5_e_mjs__WEBPACK_IMPORTED_MODULE_10__.t),
/* harmony export */   usernameClient: () => (/* binding */ usernameClient)
/* harmony export */ });
/* harmony import */ var _misc_BwNc0MKr_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../misc-BwNc0MKr.mjs */ "./node_modules/better-auth/dist/misc-BwNc0MKr.mjs");
/* harmony import */ var _url_CB8xCwz_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../url-CB8xCwz-.mjs */ "./node_modules/better-auth/dist/url-CB8xCwz-.mjs");
/* harmony import */ var _proxy_DplNCOES_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../proxy-DplNCOES.mjs */ "./node_modules/better-auth/dist/proxy-DplNCOES.mjs");
/* harmony import */ var _parser_pHp5yoAv_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../parser-pHp5yoAv.mjs */ "./node_modules/better-auth/dist/parser-pHp5yoAv.mjs");
/* harmony import */ var _client_BN9e9KX1_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../client-BN9e9KX1.mjs */ "./node_modules/better-auth/dist/client-BN9e9KX1.mjs");
/* harmony import */ var _access_Dx8TLKnw_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../access-Dx8TLKnw.mjs */ "./node_modules/better-auth/dist/access-Dx8TLKnw.mjs");
/* harmony import */ var _access_h_uttVNZ_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../access-h-uttVNZ.mjs */ "./node_modules/better-auth/dist/access-h-uttVNZ.mjs");
/* harmony import */ var _has_permission_qCjQqGds_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../has-permission-qCjQqGds.mjs */ "./node_modules/better-auth/dist/has-permission-qCjQqGds.mjs");
/* harmony import */ var _access_vPNO48H4_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../access-vPNO48H4.mjs */ "./node_modules/better-auth/dist/access-vPNO48H4.mjs");
/* harmony import */ var _permission_JwliMugl_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../permission-JwliMugl.mjs */ "./node_modules/better-auth/dist/permission-JwliMugl.mjs");
/* harmony import */ var _client_CMPEe5_e_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../client-CMPEe5-e.mjs */ "./node_modules/better-auth/dist/client-CMPEe5-e.mjs");
/* harmony import */ var nanostores__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! nanostores */ "./node_modules/nanostores/atom/index.js");













//#region src/plugins/additional-fields/client.ts
const inferAdditionalFields = (schema) => {
	return {
		id: "additional-fields-client",
		$InferServerPlugin: {}
	};
};

//#endregion
//#region src/plugins/admin/client.ts
const adminClient = (options) => {
	const roles = {
		admin: _access_h_uttVNZ_mjs__WEBPACK_IMPORTED_MODULE_6__.t,
		user: _access_h_uttVNZ_mjs__WEBPACK_IMPORTED_MODULE_6__.a,
		...options?.roles
	};
	return {
		id: "admin-client",
		$InferServerPlugin: {},
		getActions: () => ({ admin: { checkRolePermission: (data) => {
			return (0,_has_permission_qCjQqGds_mjs__WEBPACK_IMPORTED_MODULE_7__.t)({
				role: data.role,
				options: {
					ac: options?.ac,
					roles
				},
				permissions: data.permissions ?? data.permission
			});
		} } }),
		pathMethods: {
			"/admin/list-users": "GET",
			"/admin/stop-impersonating": "POST"
		}
	};
};

//#endregion
//#region src/plugins/anonymous/client.ts
const anonymousClient = () => {
	return {
		id: "anonymous",
		$InferServerPlugin: {},
		pathMethods: { "/sign-in/anonymous": "POST" },
		atomListeners: [{
			matcher: (path) => path === "/sign-in/anonymous",
			signal: "$sessionSignal"
		}]
	};
};

//#endregion
//#region src/plugins/api-key/client.ts
const apiKeyClient = () => {
	return {
		id: "api-key",
		$InferServerPlugin: {},
		pathMethods: {
			"/api-key/create": "POST",
			"/api-key/delete": "POST",
			"/api-key/delete-all-expired-api-keys": "POST"
		}
	};
};

//#endregion
//#region src/plugins/custom-session/client.ts
const customSessionClient = () => {
	return InferServerPlugin();
};

//#endregion
//#region src/plugins/device-authorization/client.ts
const deviceAuthorizationClient = () => {
	return {
		id: "device-authorization",
		$InferServerPlugin: {},
		pathMethods: {
			"/device/code": "POST",
			"/device/token": "POST",
			"/device": "GET",
			"/device/approve": "POST",
			"/device/deny": "POST"
		}
	};
};

//#endregion
//#region src/plugins/email-otp/client.ts
const emailOTPClient = () => {
	return {
		id: "email-otp",
		$InferServerPlugin: {},
		atomListeners: [{
			matcher: (path) => path === "/email-otp/verify-email" || path === "/sign-in/email-otp",
			signal: "$sessionSignal"
		}]
	};
};

//#endregion
//#region src/plugins/generic-oauth/client.ts
const genericOAuthClient = () => {
	return {
		id: "generic-oauth-client",
		$InferServerPlugin: {}
	};
};

//#endregion
//#region src/plugins/jwt/client.ts
const jwtClient = (options) => {
	const jwksPath = options?.jwks?.jwksPath ?? "/jwks";
	return {
		id: "better-auth-client",
		$InferServerPlugin: {},
		pathMethods: { [jwksPath]: "GET" },
		getActions: ($fetch) => ({ jwks: async (fetchOptions) => {
			return await $fetch(jwksPath, {
				method: "GET",
				...fetchOptions
			});
		} })
	};
};

//#endregion
//#region src/plugins/last-login-method/client.ts
function getCookieValue(name) {
	if (typeof document === "undefined") return null;
	const cookie = document.cookie.split("; ").find((row) => row.startsWith(`${name}=`));
	return cookie ? cookie.split("=")[1] : null;
}
/**
* Client-side plugin to retrieve the last used login method
*/
const lastLoginMethodClient = (config = {}) => {
	const cookieName = config.cookieName || "better-auth.last_used_login_method";
	return {
		id: "last-login-method-client",
		getActions() {
			return {
				getLastUsedLoginMethod: () => {
					return getCookieValue(cookieName);
				},
				clearLastUsedLoginMethod: () => {
					if (typeof document !== "undefined") document.cookie = `${cookieName}=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;`;
				},
				isLastUsedLoginMethod: (method) => {
					return getCookieValue(cookieName) === method;
				}
			};
		}
	};
};

//#endregion
//#region src/plugins/magic-link/client.ts
const magicLinkClient = () => {
	return {
		id: "magic-link",
		$InferServerPlugin: {}
	};
};

//#endregion
//#region src/plugins/multi-session/client.ts
const multiSessionClient = () => {
	return {
		id: "multi-session",
		$InferServerPlugin: {},
		atomListeners: [{
			matcher(path) {
				return path === "/multi-session/set-active";
			},
			signal: "$sessionSignal"
		}]
	};
};

//#endregion
//#region src/plugins/oidc-provider/client.ts
const oidcClient = () => {
	return {
		id: "oidc-client",
		$InferServerPlugin: {}
	};
};

//#endregion
//#region src/plugins/one-tap/client.ts
let isRequestInProgress = null;
function isFedCMSupported() {
	return typeof window !== "undefined" && "IdentityCredential" in window;
}
const oneTapClient = (options) => {
	return {
		id: "one-tap",
		fetchPlugins: [{
			id: "fedcm-signout-handle",
			name: "FedCM Sign-Out Handler",
			hooks: { async onResponse(ctx) {
				if (!ctx.request.url.toString().includes("/sign-out")) return;
				if (options.promptOptions?.fedCM === false || !isFedCMSupported()) return;
				navigator.credentials.preventSilentAccess();
			} }
		}],
		getActions: ($fetch, _) => {
			return { oneTap: async (opts, fetchOptions) => {
				if (isRequestInProgress && !isRequestInProgress.signal.aborted) {
					console.warn("A Google One Tap request is already in progress. Please wait.");
					return;
				}
				if (typeof window === "undefined" || !window.document) {
					console.warn("Google One Tap is only available in browser environments");
					return;
				}
				async function callback(idToken) {
					await $fetch("/one-tap/callback", {
						method: "POST",
						body: { idToken },
						...opts?.fetchOptions,
						...fetchOptions
					});
					if (!opts?.fetchOptions && !fetchOptions || opts?.callbackURL) window.location.href = opts?.callbackURL ?? "/";
				}
				const { autoSelect, cancelOnTapOutside, context } = opts ?? {};
				const contextValue = context ?? options.context ?? "signin";
				const clients = {
					fedCM: async () => {
						try {
							const identityCredential = await navigator.credentials.get({
								identity: {
									context: contextValue,
									providers: [{
										configURL: "https://accounts.google.com/gsi/fedcm.json",
										clientId: options.clientId,
										nonce: opts?.nonce
									}]
								},
								mediation: autoSelect ? "optional" : "required",
								signal: isRequestInProgress?.signal
							});
							if (!identityCredential?.token) {
								opts?.onPromptNotification?.(void 0);
								return;
							}
							try {
								await callback(identityCredential.token);
								return;
							} catch (error) {
								console.error("Error during FedCM callback:", error);
								throw error;
							}
						} catch (error) {
							if (error?.code && (error.code === 19 || error.code === 20)) {
								opts?.onPromptNotification?.(void 0);
								return;
							}
							throw error;
						}
					},
					oneTap: () => {
						return new Promise((resolve, reject) => {
							let isResolved = false;
							const baseDelay = options.promptOptions?.baseDelay ?? 1e3;
							const maxAttempts = options.promptOptions?.maxAttempts ?? 5;
							window.google?.accounts.id.initialize({
								client_id: options.clientId,
								callback: async (response) => {
									isResolved = true;
									try {
										await callback(response.credential);
										resolve();
									} catch (error) {
										console.error("Error during One Tap callback:", error);
										reject(error);
									}
								},
								auto_select: autoSelect,
								cancel_on_tap_outside: cancelOnTapOutside,
								context: contextValue,
								ux_mode: opts?.uxMode || "popup",
								nonce: opts?.nonce,
								itp_support: true,
								...options.additionalOptions
							});
							const handlePrompt = (attempt) => {
								if (isResolved) return;
								window.google?.accounts.id.prompt((notification) => {
									if (isResolved) return;
									if (notification.isDismissedMoment && notification.isDismissedMoment()) if (attempt < maxAttempts) {
										const delay = Math.pow(2, attempt) * baseDelay;
										setTimeout(() => handlePrompt(attempt + 1), delay);
									} else opts?.onPromptNotification?.(notification);
									else if (notification.isSkippedMoment && notification.isSkippedMoment()) if (attempt < maxAttempts) {
										const delay = Math.pow(2, attempt) * baseDelay;
										setTimeout(() => handlePrompt(attempt + 1), delay);
									} else opts?.onPromptNotification?.(notification);
								});
							};
							handlePrompt(0);
						});
					}
				};
				if (isRequestInProgress) isRequestInProgress?.abort();
				isRequestInProgress = new AbortController();
				try {
					const client = options.promptOptions?.fedCM === false || !isFedCMSupported() ? "oneTap" : "fedCM";
					if (client === "oneTap") await loadGoogleScript();
					await clients[client]();
				} catch (error) {
					console.error("Error during Google One Tap flow:", error);
					throw error;
				} finally {
					isRequestInProgress = null;
				}
			} };
		},
		getAtoms($fetch) {
			return {};
		}
	};
};
const loadGoogleScript = () => {
	return new Promise((resolve) => {
		if (window.googleScriptInitialized) {
			resolve();
			return;
		}
		const script = document.createElement("script");
		script.src = "https://accounts.google.com/gsi/client";
		script.async = true;
		script.defer = true;
		script.onload = () => {
			window.googleScriptInitialized = true;
			resolve();
		};
		document.head.appendChild(script);
	});
};

//#endregion
//#region src/plugins/one-time-token/client.ts
const oneTimeTokenClient = () => {
	return {
		id: "one-time-token",
		$InferServerPlugin: {}
	};
};

//#endregion
//#region src/plugins/organization/client.ts
/**
* Using the same `hasPermissionFn` function, but without the need for a `ctx` parameter or the `organizationId` parameter.
*/
const clientSideHasPermission = (input) => {
	return (0,_permission_JwliMugl_mjs__WEBPACK_IMPORTED_MODULE_9__.n)(input, input.options.roles || _access_vPNO48H4_mjs__WEBPACK_IMPORTED_MODULE_8__.r);
};
const organizationClient = (options) => {
	const $listOrg = (0,nanostores__WEBPACK_IMPORTED_MODULE_11__.atom)(false);
	const $activeOrgSignal = (0,nanostores__WEBPACK_IMPORTED_MODULE_11__.atom)(false);
	const $activeMemberSignal = (0,nanostores__WEBPACK_IMPORTED_MODULE_11__.atom)(false);
	const $activeMemberRoleSignal = (0,nanostores__WEBPACK_IMPORTED_MODULE_11__.atom)(false);
	const roles = {
		admin: _access_vPNO48H4_mjs__WEBPACK_IMPORTED_MODULE_8__.t,
		member: _access_vPNO48H4_mjs__WEBPACK_IMPORTED_MODULE_8__.a,
		owner: _access_vPNO48H4_mjs__WEBPACK_IMPORTED_MODULE_8__.o,
		...options?.roles
	};
	return {
		id: "organization",
		$InferServerPlugin: {},
		getActions: ($fetch, _$store, co) => ({
			$Infer: {
				ActiveOrganization: {},
				Organization: {},
				Invitation: {},
				Member: {},
				Team: {}
			},
			organization: { checkRolePermission: (data) => {
				return clientSideHasPermission({
					role: data.role,
					options: {
						ac: options?.ac,
						roles
					},
					permissions: data.permissions ?? data.permission
				});
			} }
		}),
		getAtoms: ($fetch) => {
			const listOrganizations = (0,_proxy_DplNCOES_mjs__WEBPACK_IMPORTED_MODULE_2__.i)($listOrg, "/organization/list", $fetch, { method: "GET" });
			return {
				$listOrg,
				$activeOrgSignal,
				$activeMemberSignal,
				$activeMemberRoleSignal,
				activeOrganization: (0,_proxy_DplNCOES_mjs__WEBPACK_IMPORTED_MODULE_2__.i)([$activeOrgSignal], "/organization/get-full-organization", $fetch, () => ({ method: "GET" })),
				listOrganizations,
				activeMember: (0,_proxy_DplNCOES_mjs__WEBPACK_IMPORTED_MODULE_2__.i)([$activeMemberSignal], "/organization/get-active-member", $fetch, { method: "GET" }),
				activeMemberRole: (0,_proxy_DplNCOES_mjs__WEBPACK_IMPORTED_MODULE_2__.i)([$activeMemberRoleSignal], "/organization/get-active-member-role", $fetch, { method: "GET" })
			};
		},
		pathMethods: {
			"/organization/get-full-organization": "GET",
			"/organization/list-user-teams": "GET"
		},
		atomListeners: [
			{
				matcher(path) {
					return path === "/organization/create" || path === "/organization/delete" || path === "/organization/update";
				},
				signal: "$listOrg"
			},
			{
				matcher(path) {
					return path.startsWith("/organization");
				},
				signal: "$activeOrgSignal"
			},
			{
				matcher(path) {
					return path.startsWith("/organization/set-active");
				},
				signal: "$sessionSignal"
			},
			{
				matcher(path) {
					return path.includes("/organization/update-member-role");
				},
				signal: "$activeMemberSignal"
			},
			{
				matcher(path) {
					return path.includes("/organization/update-member-role");
				},
				signal: "$activeMemberRoleSignal"
			}
		]
	};
};
const inferOrgAdditionalFields = (schema) => {
	return {};
};

//#endregion
//#region src/plugins/phone-number/client.ts
const phoneNumberClient = () => {
	return {
		id: "phoneNumber",
		$InferServerPlugin: {},
		atomListeners: [{
			matcher(path) {
				return path === "/phone-number/update" || path === "/phone-number/verify" || path === "/sign-in/phone-number";
			},
			signal: "$sessionSignal"
		}]
	};
};

//#endregion
//#region src/plugins/siwe/client.ts
const siweClient = () => {
	return {
		id: "siwe",
		$InferServerPlugin: {}
	};
};

//#endregion
//#region src/plugins/username/client.ts
const usernameClient = () => {
	return {
		id: "username",
		$InferServerPlugin: {},
		atomListeners: [{
			matcher: (path) => path === "/sign-in/username",
			signal: "$sessionSignal"
		}]
	};
};

//#endregion
//#region src/client/plugins/infer-plugin.ts
const InferServerPlugin = () => {
	return {
		id: "infer-server-plugin",
		$InferServerPlugin: {}
	};
};

//#endregion


/***/ }),

/***/ "./node_modules/better-auth/dist/has-permission-qCjQqGds.mjs":
/*!*******************************************************************!*\
  !*** ./node_modules/better-auth/dist/has-permission-qCjQqGds.mjs ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   t: () => (/* binding */ hasPermission)
/* harmony export */ });
/* harmony import */ var _access_h_uttVNZ_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./access-h-uttVNZ.mjs */ "./node_modules/better-auth/dist/access-h-uttVNZ.mjs");


//#region src/plugins/admin/has-permission.ts
const hasPermission = (input) => {
	if (input.userId && input.options?.adminUserIds?.includes(input.userId)) return true;
	if (!input.permissions && !input.permission) return false;
	const roles = (input.role || input.options?.defaultRole || "user").split(",");
	const acRoles = input.options?.roles || _access_h_uttVNZ_mjs__WEBPACK_IMPORTED_MODULE_0__.r;
	for (const role of roles) if ((acRoles[role]?.authorize(input.permission ?? input.permissions))?.success) return true;
	return false;
};

//#endregion


/***/ }),

/***/ "./node_modules/better-auth/dist/misc-BwNc0MKr.mjs":
/*!*********************************************************!*\
  !*** ./node_modules/better-auth/dist/misc-BwNc0MKr.mjs ***!
  \*********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   t: () => (/* binding */ capitalizeFirstLetter)
/* harmony export */ });
//#region src/utils/misc.ts
function capitalizeFirstLetter(str) {
	return str.charAt(0).toUpperCase() + str.slice(1);
}

//#endregion


/***/ }),

/***/ "./node_modules/better-auth/dist/parser-pHp5yoAv.mjs":
/*!***********************************************************!*\
  !*** ./node_modules/better-auth/dist/parser-pHp5yoAv.mjs ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   n: () => (/* binding */ parser_default),
/* harmony export */   t: () => (/* binding */ parseJSON)
/* harmony export */ });
//#region src/client/parser.ts
const PROTO_POLLUTION_PATTERNS = {
	proto: /"(?:_|\\u0{2}5[Ff]){2}(?:p|\\u0{2}70)(?:r|\\u0{2}72)(?:o|\\u0{2}6[Ff])(?:t|\\u0{2}74)(?:o|\\u0{2}6[Ff])(?:_|\\u0{2}5[Ff]){2}"\s*:/,
	constructor: /"(?:c|\\u0063)(?:o|\\u006[Ff])(?:n|\\u006[Ee])(?:s|\\u0073)(?:t|\\u0074)(?:r|\\u0072)(?:u|\\u0075)(?:c|\\u0063)(?:t|\\u0074)(?:o|\\u006[Ff])(?:r|\\u0072)"\s*:/,
	protoShort: /"__proto__"\s*:/,
	constructorShort: /"constructor"\s*:/
};
const JSON_SIGNATURE = /^\s*["[{]|^\s*-?\d{1,16}(\.\d{1,17})?([Ee][+-]?\d+)?\s*$/;
const SPECIAL_VALUES = {
	true: true,
	false: false,
	null: null,
	undefined: void 0,
	nan: NaN,
	infinity: Number.POSITIVE_INFINITY,
	"-infinity": Number.NEGATIVE_INFINITY
};
const ISO_DATE_REGEX = /^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2})(?:\.(\d{1,7}))?(?:Z|([+-])(\d{2}):(\d{2}))$/;
function isValidDate(date) {
	return date instanceof Date && !isNaN(date.getTime());
}
function parseISODate(value) {
	const match = ISO_DATE_REGEX.exec(value);
	if (!match) return null;
	const [, year, month, day, hour, minute, second, ms, offsetSign, offsetHour, offsetMinute] = match;
	let date = new Date(Date.UTC(parseInt(year, 10), parseInt(month, 10) - 1, parseInt(day, 10), parseInt(hour, 10), parseInt(minute, 10), parseInt(second, 10), ms ? parseInt(ms.padEnd(3, "0"), 10) : 0));
	if (offsetSign) {
		const offset = (parseInt(offsetHour, 10) * 60 + parseInt(offsetMinute, 10)) * (offsetSign === "+" ? -1 : 1);
		date.setUTCMinutes(date.getUTCMinutes() + offset);
	}
	return isValidDate(date) ? date : null;
}
function betterJSONParse(value, options = {}) {
	const { strict = false, warnings = false, reviver, parseDates = true } = options;
	if (typeof value !== "string") return value;
	const trimmed = value.trim();
	if (trimmed.length > 0 && trimmed[0] === "\"" && trimmed.endsWith("\"") && !trimmed.slice(1, -1).includes("\"")) return trimmed.slice(1, -1);
	const lowerValue = trimmed.toLowerCase();
	if (lowerValue.length <= 9 && lowerValue in SPECIAL_VALUES) return SPECIAL_VALUES[lowerValue];
	if (!JSON_SIGNATURE.test(trimmed)) {
		if (strict) throw new SyntaxError("[better-json] Invalid JSON");
		return value;
	}
	if (Object.entries(PROTO_POLLUTION_PATTERNS).some(([key, pattern]) => {
		const matches = pattern.test(trimmed);
		if (matches && warnings) console.warn(`[better-json] Detected potential prototype pollution attempt using ${key} pattern`);
		return matches;
	}) && strict) throw new Error("[better-json] Potential prototype pollution attempt detected");
	try {
		const secureReviver = (key, value$1) => {
			if (key === "__proto__" || key === "constructor" && value$1 && typeof value$1 === "object" && "prototype" in value$1) {
				if (warnings) console.warn(`[better-json] Dropping "${key}" key to prevent prototype pollution`);
				return;
			}
			if (parseDates && typeof value$1 === "string") {
				const date = parseISODate(value$1);
				if (date) return date;
			}
			return reviver ? reviver(key, value$1) : value$1;
		};
		return JSON.parse(trimmed, secureReviver);
	} catch (error) {
		if (strict) throw error;
		return value;
	}
}
function parseJSON(value, options = { strict: true }) {
	return betterJSONParse(value, options);
}
var parser_default = parseJSON;

//#endregion


/***/ }),

/***/ "./node_modules/better-auth/dist/permission-JwliMugl.mjs":
/*!***************************************************************!*\
  !*** ./node_modules/better-auth/dist/permission-JwliMugl.mjs ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   n: () => (/* binding */ hasPermissionFn),
/* harmony export */   t: () => (/* binding */ cacheAllRoles)
/* harmony export */ });
//#region src/plugins/organization/permission.ts
const hasPermissionFn = (input, acRoles) => {
	if (!input.permissions && !input.permission) return false;
	const roles = input.role.split(",");
	const creatorRole = input.options.creatorRole || "owner";
	const isCreator = roles.includes(creatorRole);
	const allowCreatorsAllPermissions = input.allowCreatorAllPermissions || false;
	if (isCreator && allowCreatorsAllPermissions) return true;
	for (const role of roles) if ((acRoles[role]?.authorize(input.permissions ?? input.permission))?.success) return true;
	return false;
};
let cacheAllRoles = /* @__PURE__ */ new Map();

//#endregion


/***/ }),

/***/ "./node_modules/better-auth/dist/proxy-DplNCOES.mjs":
/*!**********************************************************!*\
  !*** ./node_modules/better-auth/dist/proxy-DplNCOES.mjs ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   a: () => (/* binding */ kOnlineManager),
/* harmony export */   c: () => (/* binding */ kBroadcastChannel),
/* harmony export */   i: () => (/* binding */ useAuthQuery),
/* harmony export */   n: () => (/* binding */ getClientConfig),
/* harmony export */   o: () => (/* binding */ kFocusManager),
/* harmony export */   r: () => (/* binding */ createSessionRefreshManager),
/* harmony export */   s: () => (/* binding */ getGlobalBroadcastChannel),
/* harmony export */   t: () => (/* binding */ createDynamicPathProxy)
/* harmony export */ });
/* harmony import */ var _url_CB8xCwz_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./url-CB8xCwz-.mjs */ "./node_modules/better-auth/dist/url-CB8xCwz-.mjs");
/* harmony import */ var _parser_pHp5yoAv_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parser-pHp5yoAv.mjs */ "./node_modules/better-auth/dist/parser-pHp5yoAv.mjs");
/* harmony import */ var nanostores__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! nanostores */ "./node_modules/nanostores/atom/index.js");
/* harmony import */ var nanostores__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! nanostores */ "./node_modules/nanostores/lifecycle/index.js");
/* harmony import */ var _better_fetch_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @better-fetch/fetch */ "./node_modules/@better-fetch/fetch/dist/index.js");





//#region src/client/broadcast-channel.ts
const kBroadcastChannel = Symbol.for("better-auth:broadcast-channel");
const now$1 = () => Math.floor(Date.now() / 1e3);
var WindowBroadcastChannel = class {
	listeners = /* @__PURE__ */ new Set();
	name;
	constructor(name = "better-auth.message") {
		this.name = name;
	}
	subscribe(listener) {
		this.listeners.add(listener);
		return () => {
			this.listeners.delete(listener);
		};
	}
	post(message) {
		if (typeof window === "undefined") return;
		try {
			localStorage.setItem(this.name, JSON.stringify({
				...message,
				timestamp: now$1()
			}));
		} catch {}
	}
	setup() {
		if (typeof window === "undefined" || typeof window.addEventListener === "undefined") return () => {};
		const handler = (event) => {
			if (event.key !== this.name) return;
			const message = JSON.parse(event.newValue ?? "{}");
			if (message?.event !== "session" || !message?.data) return;
			this.listeners.forEach((listener) => listener(message));
		};
		window.addEventListener("storage", handler);
		return () => {
			window.removeEventListener("storage", handler);
		};
	}
};
function getGlobalBroadcastChannel(name = "better-auth.message") {
	if (!globalThis[kBroadcastChannel]) globalThis[kBroadcastChannel] = new WindowBroadcastChannel(name);
	return globalThis[kBroadcastChannel];
}

//#endregion
//#region src/client/focus-manager.ts
const kFocusManager = Symbol.for("better-auth:focus-manager");
var WindowFocusManager = class {
	listeners = /* @__PURE__ */ new Set();
	subscribe(listener) {
		this.listeners.add(listener);
		return () => {
			this.listeners.delete(listener);
		};
	}
	setFocused(focused) {
		this.listeners.forEach((listener) => listener(focused));
	}
	setup() {
		if (typeof window === "undefined" || typeof document === "undefined" || typeof window.addEventListener === "undefined") return () => {};
		const visibilityHandler = () => {
			if (document.visibilityState === "visible") this.setFocused(true);
		};
		document.addEventListener("visibilitychange", visibilityHandler, false);
		return () => {
			document.removeEventListener("visibilitychange", visibilityHandler, false);
		};
	}
};
function getGlobalFocusManager() {
	if (!globalThis[kFocusManager]) globalThis[kFocusManager] = new WindowFocusManager();
	return globalThis[kFocusManager];
}

//#endregion
//#region src/client/online-manager.ts
const kOnlineManager = Symbol.for("better-auth:online-manager");
var WindowOnlineManager = class {
	listeners = /* @__PURE__ */ new Set();
	isOnline = typeof navigator !== "undefined" ? navigator.onLine : true;
	subscribe(listener) {
		this.listeners.add(listener);
		return () => {
			this.listeners.delete(listener);
		};
	}
	setOnline(online) {
		this.isOnline = online;
		this.listeners.forEach((listener) => listener(online));
	}
	setup() {
		if (typeof window === "undefined" || typeof window.addEventListener === "undefined") return () => {};
		const onOnline = () => this.setOnline(true);
		const onOffline = () => this.setOnline(false);
		window.addEventListener("online", onOnline, false);
		window.addEventListener("offline", onOffline, false);
		return () => {
			window.removeEventListener("online", onOnline, false);
			window.removeEventListener("offline", onOffline, false);
		};
	}
};
function getGlobalOnlineManager() {
	if (!globalThis[kOnlineManager]) globalThis[kOnlineManager] = new WindowOnlineManager();
	return globalThis[kOnlineManager];
}

//#endregion
//#region src/client/query.ts
const isServer = () => typeof window === "undefined";
const useAuthQuery = (initializedAtom, path, $fetch, options) => {
	const value = (0,nanostores__WEBPACK_IMPORTED_MODULE_3__.atom)({
		data: null,
		error: null,
		isPending: true,
		isRefetching: false,
		refetch: (queryParams) => fn(queryParams)
	});
	const fn = async (queryParams) => {
		return new Promise((resolve) => {
			const opts = typeof options === "function" ? options({
				data: value.get().data,
				error: value.get().error,
				isPending: value.get().isPending
			}) : options;
			$fetch(path, {
				...opts,
				query: {
					...opts?.query,
					...queryParams?.query
				},
				async onSuccess(context) {
					value.set({
						data: context.data,
						error: null,
						isPending: false,
						isRefetching: false,
						refetch: value.value.refetch
					});
					await opts?.onSuccess?.(context);
				},
				async onError(context) {
					const { request } = context;
					const retryAttempts = typeof request.retry === "number" ? request.retry : request.retry?.attempts;
					const retryAttempt = request.retryAttempt || 0;
					if (retryAttempts && retryAttempt < retryAttempts) return;
					value.set({
						error: context.error,
						data: null,
						isPending: false,
						isRefetching: false,
						refetch: value.value.refetch
					});
					await opts?.onError?.(context);
				},
				async onRequest(context) {
					const currentValue = value.get();
					value.set({
						isPending: currentValue.data === null,
						data: currentValue.data,
						error: null,
						isRefetching: true,
						refetch: value.value.refetch
					});
					await opts?.onRequest?.(context);
				}
			}).catch((error) => {
				value.set({
					error,
					data: null,
					isPending: false,
					isRefetching: false,
					refetch: value.value.refetch
				});
			}).finally(() => {
				resolve(void 0);
			});
		});
	};
	initializedAtom = Array.isArray(initializedAtom) ? initializedAtom : [initializedAtom];
	let isMounted = false;
	for (const initAtom of initializedAtom) initAtom.subscribe(async () => {
		if (isServer()) return;
		if (isMounted) await fn();
		else (0,nanostores__WEBPACK_IMPORTED_MODULE_4__.onMount)(value, () => {
			const timeoutId = setTimeout(async () => {
				if (!isMounted) {
					await fn();
					isMounted = true;
				}
			}, 0);
			return () => {
				value.off();
				initAtom.off();
				clearTimeout(timeoutId);
			};
		});
	});
	return value;
};

//#endregion
//#region src/client/session-refresh.ts
const now = () => Math.floor(Date.now() / 1e3);
/**
* Rate limit: don't refetch on focus if a session request was made within this many seconds
*/
const FOCUS_REFETCH_RATE_LIMIT_SECONDS = 5;
function createSessionRefreshManager(opts) {
	const { sessionAtom, sessionSignal, $fetch, options = {} } = opts;
	const refetchInterval = options.sessionOptions?.refetchInterval ?? 0;
	const refetchOnWindowFocus = options.sessionOptions?.refetchOnWindowFocus ?? true;
	const refetchWhenOffline = options.sessionOptions?.refetchWhenOffline ?? false;
	const state = {
		lastSync: 0,
		lastSessionRequest: 0,
		cachedSession: void 0
	};
	const shouldRefetch = () => {
		return refetchWhenOffline || getGlobalOnlineManager().isOnline;
	};
	const triggerRefetch = (event) => {
		if (!shouldRefetch()) return;
		if (event?.event === "storage") {
			state.lastSync = now();
			sessionSignal.set(!sessionSignal.get());
			return;
		}
		const currentSession = sessionAtom.get();
		if (event?.event === "poll") {
			state.lastSessionRequest = now();
			$fetch("/get-session").then((res) => {
				sessionAtom.set({
					...currentSession,
					data: res.data,
					error: res.error || null
				});
				state.lastSync = now();
				sessionSignal.set(!sessionSignal.get());
			}).catch(() => {});
			return;
		}
		if (event?.event === "visibilitychange") {
			if (now() - state.lastSessionRequest < FOCUS_REFETCH_RATE_LIMIT_SECONDS && currentSession?.data !== null && currentSession?.data !== void 0) return;
		}
		if (currentSession?.data === null || currentSession?.data === void 0 || event?.event === "visibilitychange") {
			if (event?.event === "visibilitychange") state.lastSessionRequest = now();
			state.lastSync = now();
			sessionSignal.set(!sessionSignal.get());
		}
	};
	const broadcastSessionUpdate = (trigger) => {
		getGlobalBroadcastChannel().post({
			event: "session",
			data: { trigger },
			clientId: Math.random().toString(36).substring(7)
		});
	};
	const setupPolling = () => {
		if (refetchInterval && refetchInterval > 0) state.pollInterval = setInterval(() => {
			if (sessionAtom.get()?.data) triggerRefetch({ event: "poll" });
		}, refetchInterval * 1e3);
	};
	const setupBroadcast = () => {
		state.unsubscribeBroadcast = getGlobalBroadcastChannel().subscribe(() => {
			triggerRefetch({ event: "storage" });
		});
	};
	const setupFocusRefetch = () => {
		if (!refetchOnWindowFocus) return;
		state.unsubscribeFocus = getGlobalFocusManager().subscribe(() => {
			triggerRefetch({ event: "visibilitychange" });
		});
	};
	const setupOnlineRefetch = () => {
		state.unsubscribeOnline = getGlobalOnlineManager().subscribe((online) => {
			if (online) triggerRefetch({ event: "visibilitychange" });
		});
	};
	const init = () => {
		setupPolling();
		setupBroadcast();
		setupFocusRefetch();
		setupOnlineRefetch();
		getGlobalBroadcastChannel().setup();
		getGlobalFocusManager().setup();
		getGlobalOnlineManager().setup();
	};
	const cleanup = () => {
		if (state.pollInterval) {
			clearInterval(state.pollInterval);
			state.pollInterval = void 0;
		}
		if (state.unsubscribeBroadcast) {
			state.unsubscribeBroadcast();
			state.unsubscribeBroadcast = void 0;
		}
		if (state.unsubscribeFocus) {
			state.unsubscribeFocus();
			state.unsubscribeFocus = void 0;
		}
		if (state.unsubscribeOnline) {
			state.unsubscribeOnline();
			state.unsubscribeOnline = void 0;
		}
		state.lastSync = 0;
		state.lastSessionRequest = 0;
		state.cachedSession = void 0;
	};
	return {
		init,
		cleanup,
		triggerRefetch,
		broadcastSessionUpdate
	};
}

//#endregion
//#region src/client/fetch-plugins.ts
const redirectPlugin = {
	id: "redirect",
	name: "Redirect",
	hooks: { onSuccess(context) {
		if (context.data?.url && context.data?.redirect) {
			if (typeof window !== "undefined" && window.location) {
				if (window.location) try {
					window.location.href = context.data.url;
				} catch {}
			}
		}
	} }
};

//#endregion
//#region src/client/session-atom.ts
function getSessionAtom($fetch, options) {
	const $signal = (0,nanostores__WEBPACK_IMPORTED_MODULE_3__.atom)(false);
	const session = useAuthQuery($signal, "/get-session", $fetch, { method: "GET" });
	(0,nanostores__WEBPACK_IMPORTED_MODULE_4__.onMount)(session, () => {
		const refreshManager = createSessionRefreshManager({
			sessionAtom: session,
			sessionSignal: $signal,
			$fetch,
			options
		});
		refreshManager.init();
		return () => {
			refreshManager.cleanup();
		};
	});
	return {
		session,
		$sessionSignal: $signal
	};
}

//#endregion
//#region src/client/config.ts
const getClientConfig = (options, loadEnv) => {
	const isCredentialsSupported = "credentials" in Request.prototype;
	const baseURL = (0,_url_CB8xCwz_mjs__WEBPACK_IMPORTED_MODULE_0__.t)(options?.baseURL, options?.basePath, void 0, loadEnv) ?? "/api/auth";
	const pluginsFetchPlugins = options?.plugins?.flatMap((plugin) => plugin.fetchPlugins).filter((pl) => pl !== void 0) || [];
	const lifeCyclePlugin = {
		id: "lifecycle-hooks",
		name: "lifecycle-hooks",
		hooks: {
			onSuccess: options?.fetchOptions?.onSuccess,
			onError: options?.fetchOptions?.onError,
			onRequest: options?.fetchOptions?.onRequest,
			onResponse: options?.fetchOptions?.onResponse
		}
	};
	const { onSuccess, onError, onRequest, onResponse, ...restOfFetchOptions } = options?.fetchOptions || {};
	const $fetch = (0,_better_fetch_fetch__WEBPACK_IMPORTED_MODULE_2__.createFetch)({
		baseURL,
		...isCredentialsSupported ? { credentials: "include" } : {},
		method: "GET",
		jsonParser(text) {
			if (!text) return null;
			return (0,_parser_pHp5yoAv_mjs__WEBPACK_IMPORTED_MODULE_1__.t)(text, { strict: false });
		},
		customFetchImpl: fetch,
		...restOfFetchOptions,
		plugins: [
			lifeCyclePlugin,
			...restOfFetchOptions.plugins || [],
			...options?.disableDefaultFetchPlugins ? [] : [redirectPlugin],
			...pluginsFetchPlugins
		]
	});
	const { $sessionSignal, session } = getSessionAtom($fetch, options);
	const plugins = options?.plugins || [];
	let pluginsActions = {};
	let pluginsAtoms = {
		$sessionSignal,
		session
	};
	let pluginPathMethods = {
		"/sign-out": "POST",
		"/revoke-sessions": "POST",
		"/revoke-other-sessions": "POST",
		"/delete-user": "POST"
	};
	const atomListeners = [{
		signal: "$sessionSignal",
		matcher(path) {
			return path === "/sign-out" || path === "/update-user" || path === "/sign-up/email" || path === "/sign-in/email" || path === "/delete-user" || path === "/verify-email" || path === "/revoke-sessions" || path === "/revoke-session" || path === "/change-email";
		}
	}];
	for (const plugin of plugins) {
		if (plugin.getAtoms) Object.assign(pluginsAtoms, plugin.getAtoms?.($fetch));
		if (plugin.pathMethods) Object.assign(pluginPathMethods, plugin.pathMethods);
		if (plugin.atomListeners) atomListeners.push(...plugin.atomListeners);
	}
	const $store = {
		notify: (signal) => {
			pluginsAtoms[signal].set(!pluginsAtoms[signal].get());
		},
		listen: (signal, listener) => {
			pluginsAtoms[signal].subscribe(listener);
		},
		atoms: pluginsAtoms
	};
	for (const plugin of plugins) if (plugin.getActions) Object.assign(pluginsActions, plugin.getActions?.($fetch, $store, options));
	return {
		get baseURL() {
			return baseURL;
		},
		pluginsActions,
		pluginsAtoms,
		pluginPathMethods,
		atomListeners,
		$fetch,
		$store
	};
};

//#endregion
//#region src/utils/is-atom.ts
function isAtom(value) {
	return typeof value === "object" && value !== null && "get" in value && typeof value.get === "function" && "lc" in value && typeof value.lc === "number";
}

//#endregion
//#region src/client/proxy.ts
function getMethod(path, knownPathMethods, args) {
	const method = knownPathMethods[path];
	const { fetchOptions, query, ...body } = args || {};
	if (method) return method;
	if (fetchOptions?.method) return fetchOptions.method;
	if (body && Object.keys(body).length > 0) return "POST";
	return "GET";
}
function createDynamicPathProxy(routes, client, knownPathMethods, atoms, atomListeners) {
	function createProxy(path = []) {
		return new Proxy(function() {}, {
			get(_, prop) {
				if (typeof prop !== "string") return;
				if (prop === "then" || prop === "catch" || prop === "finally") return;
				const fullPath = [...path, prop];
				let current = routes;
				for (const segment of fullPath) if (current && typeof current === "object" && segment in current) current = current[segment];
				else {
					current = void 0;
					break;
				}
				if (typeof current === "function") return current;
				if (isAtom(current)) return current;
				return createProxy(fullPath);
			},
			apply: async (_, __, args) => {
				const routePath = "/" + path.map((segment) => segment.replace(/[A-Z]/g, (letter) => `-${letter.toLowerCase()}`)).join("/");
				const arg = args[0] || {};
				const fetchOptions = args[1] || {};
				const { query, fetchOptions: argFetchOptions, ...body } = arg;
				const options = {
					...fetchOptions,
					...argFetchOptions
				};
				const method = getMethod(routePath, knownPathMethods, arg);
				return await client(routePath, {
					...options,
					body: method === "GET" ? void 0 : {
						...body,
						...options?.body || {}
					},
					query: query || options?.query,
					method,
					async onSuccess(context) {
						await options?.onSuccess?.(context);
						if (!atomListeners || options.disableSignal) return;
						/**
						* We trigger listeners
						*/
						const matches = atomListeners.filter((s) => s.matcher(routePath));
						if (!matches.length) return;
						for (const match of matches) {
							const signal = atoms[match.signal];
							if (!signal) return;
							/**
							* To avoid race conditions we set the signal in a setTimeout
							*/
							const val = signal.get();
							setTimeout(() => {
								signal.set(!val);
							}, 10);
						}
					}
				});
			}
		});
	}
	return createProxy();
}

//#endregion


/***/ }),

/***/ "./node_modules/better-auth/dist/url-CB8xCwz-.mjs":
/*!********************************************************!*\
  !*** ./node_modules/better-auth/dist/url-CB8xCwz-.mjs ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   i: () => (/* binding */ getProtocol),
/* harmony export */   n: () => (/* binding */ getHost),
/* harmony export */   r: () => (/* binding */ getOrigin),
/* harmony export */   t: () => (/* binding */ getBaseURL)
/* harmony export */ });
/* harmony import */ var _better_auth_core_env__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @better-auth/core/env */ "./node_modules/@better-auth/core/dist/env/index.mjs");
/* harmony import */ var _better_auth_core_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @better-auth/core/error */ "./node_modules/@better-auth/core/dist/error/index.mjs");



//#region src/utils/url.ts
function checkHasPath(url) {
	try {
		return (new URL(url).pathname.replace(/\/+$/, "") || "/") !== "/";
	} catch (error) {
		throw new _better_auth_core_error__WEBPACK_IMPORTED_MODULE_1__.BetterAuthError(`Invalid base URL: ${url}. Please provide a valid base URL.`);
	}
}
function assertHasProtocol(url) {
	try {
		const parsedUrl = new URL(url);
		if (parsedUrl.protocol !== "http:" && parsedUrl.protocol !== "https:") throw new _better_auth_core_error__WEBPACK_IMPORTED_MODULE_1__.BetterAuthError(`Invalid base URL: ${url}. URL must include 'http://' or 'https://'`);
	} catch (error) {
		if (error instanceof _better_auth_core_error__WEBPACK_IMPORTED_MODULE_1__.BetterAuthError) throw error;
		throw new _better_auth_core_error__WEBPACK_IMPORTED_MODULE_1__.BetterAuthError(`Invalid base URL: ${url}. Please provide a valid base URL.`, String(error));
	}
}
function withPath(url, path = "/api/auth") {
	assertHasProtocol(url);
	if (checkHasPath(url)) return url;
	const trimmedUrl = url.replace(/\/+$/, "");
	if (!path || path === "/") return trimmedUrl;
	path = path.startsWith("/") ? path : `/${path}`;
	return `${trimmedUrl}${path}`;
}
function getBaseURL(url, path, request, loadEnv, trustedProxyHeaders) {
	if (url) return withPath(url, path);
	if (loadEnv !== false) {
		const fromEnv = _better_auth_core_env__WEBPACK_IMPORTED_MODULE_0__.env.BETTER_AUTH_URL || _better_auth_core_env__WEBPACK_IMPORTED_MODULE_0__.env.NEXT_PUBLIC_BETTER_AUTH_URL || _better_auth_core_env__WEBPACK_IMPORTED_MODULE_0__.env.PUBLIC_BETTER_AUTH_URL || _better_auth_core_env__WEBPACK_IMPORTED_MODULE_0__.env.NUXT_PUBLIC_BETTER_AUTH_URL || _better_auth_core_env__WEBPACK_IMPORTED_MODULE_0__.env.NUXT_PUBLIC_AUTH_URL || (_better_auth_core_env__WEBPACK_IMPORTED_MODULE_0__.env.BASE_URL !== "/" ? _better_auth_core_env__WEBPACK_IMPORTED_MODULE_0__.env.BASE_URL : void 0);
		if (fromEnv) return withPath(fromEnv, path);
	}
	const fromRequest = request?.headers.get("x-forwarded-host");
	const fromRequestProto = request?.headers.get("x-forwarded-proto");
	if (fromRequest && fromRequestProto && trustedProxyHeaders) return withPath(`${fromRequestProto}://${fromRequest}`, path);
	if (request) {
		const url$1 = getOrigin(request.url);
		if (!url$1) throw new _better_auth_core_error__WEBPACK_IMPORTED_MODULE_1__.BetterAuthError("Could not get origin from request. Please provide a valid base URL.");
		return withPath(url$1, path);
	}
	if (typeof window !== "undefined" && window.location) return withPath(window.location.origin, path);
}
function getOrigin(url) {
	try {
		const parsedUrl = new URL(url);
		return parsedUrl.origin === "null" ? null : parsedUrl.origin;
	} catch (error) {
		return null;
	}
}
function getProtocol(url) {
	try {
		return new URL(url).protocol;
	} catch (error) {
		return null;
	}
}
function getHost(url) {
	try {
		return new URL(url).host;
	} catch (error) {
		return null;
	}
}

//#endregion


/***/ }),

/***/ "./node_modules/nanostores/atom/index.js":
/*!***********************************************!*\
  !*** ./node_modules/nanostores/atom/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   atom: () => (/* binding */ atom),
/* harmony export */   epoch: () => (/* binding */ epoch),
/* harmony export */   readonlyType: () => (/* binding */ readonlyType)
/* harmony export */ });
/* harmony import */ var _clean_stores_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../clean-stores/index.js */ "./node_modules/nanostores/clean-stores/index.js");


let listenerQueue = []
let lqIndex = 0
const QUEUE_ITEMS_PER_LISTENER = 4
let epoch = 0

/* @__NO_SIDE_EFFECTS__ */
const atom = initialValue => {
  let listeners = []
  let $atom = {
    get() {
      if (!$atom.lc) {
        $atom.listen(() => {})()
      }
      return $atom.value
    },
    lc: 0,
    listen(listener) {
      $atom.lc = listeners.push(listener)

      return () => {
        for (
          let i = lqIndex + QUEUE_ITEMS_PER_LISTENER;
          i < listenerQueue.length;

        ) {
          if (listenerQueue[i] === listener) {
            listenerQueue.splice(i, QUEUE_ITEMS_PER_LISTENER)
          } else {
            i += QUEUE_ITEMS_PER_LISTENER
          }
        }

        let index = listeners.indexOf(listener)
        if (~index) {
          listeners.splice(index, 1)
          if (!--$atom.lc) $atom.off()
        }
      }
    },
    notify(oldValue, changedKey) {
      epoch++
      let runListenerQueue = !listenerQueue.length
      for (let listener of listeners) {
        listenerQueue.push(listener, $atom.value, oldValue, changedKey)
      }

      if (runListenerQueue) {
        for (
          lqIndex = 0;
          lqIndex < listenerQueue.length;
          lqIndex += QUEUE_ITEMS_PER_LISTENER
        ) {
          listenerQueue[lqIndex](
            listenerQueue[lqIndex + 1],
            listenerQueue[lqIndex + 2],
            listenerQueue[lqIndex + 3]
          )
        }
        listenerQueue.length = 0
      }
    },
    /* It will be called on last listener unsubscribing.
       We will redefine it in onMount and onStop. */
    off() {},
    set(newValue) {
      let oldValue = $atom.value
      if (oldValue !== newValue) {
        $atom.value = newValue
        $atom.notify(oldValue)
      }
    },
    subscribe(listener) {
      let unbind = $atom.listen(listener)
      listener($atom.value)
      return unbind
    },
    value: initialValue
  }

  if (true) {
    $atom[_clean_stores_index_js__WEBPACK_IMPORTED_MODULE_0__.clean] = () => {
      listeners = []
      $atom.lc = 0
      $atom.off()
    }
  }

  return $atom
}

const readonlyType = store => store


/***/ }),

/***/ "./node_modules/nanostores/clean-stores/index.js":
/*!*******************************************************!*\
  !*** ./node_modules/nanostores/clean-stores/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   clean: () => (/* binding */ clean),
/* harmony export */   cleanStores: () => (/* binding */ cleanStores)
/* harmony export */ });
/* harmony import */ var _task_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../task/index.js */ "./node_modules/nanostores/task/index.js");


let clean = Symbol('clean')

let cleanStores = (...stores) => {
  if (false) {}
  (0,_task_index_js__WEBPACK_IMPORTED_MODULE_0__.cleanTasks)()
  for (let $store of stores) {
    if ($store) {
      if ($store.mocked) delete $store.mocked
      if ($store[clean]) $store[clean]()
    }
  }
}


/***/ }),

/***/ "./node_modules/nanostores/lifecycle/index.js":
/*!****************************************************!*\
  !*** ./node_modules/nanostores/lifecycle/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STORE_UNMOUNT_DELAY: () => (/* binding */ STORE_UNMOUNT_DELAY),
/* harmony export */   on: () => (/* binding */ on),
/* harmony export */   onMount: () => (/* binding */ onMount),
/* harmony export */   onNotify: () => (/* binding */ onNotify),
/* harmony export */   onSet: () => (/* binding */ onSet),
/* harmony export */   onStart: () => (/* binding */ onStart),
/* harmony export */   onStop: () => (/* binding */ onStop)
/* harmony export */ });
/* harmony import */ var _clean_stores_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../clean-stores/index.js */ "./node_modules/nanostores/clean-stores/index.js");


const START = 0
const STOP = 1
const SET = 2
const NOTIFY = 3
const MOUNT = 5
const UNMOUNT = 6
const REVERT_MUTATION = 10

let on = (object, listener, eventKey, mutateStore) => {
  object.events = object.events || {}
  if (!object.events[eventKey + REVERT_MUTATION]) {
    object.events[eventKey + REVERT_MUTATION] = mutateStore(eventProps => {
      // eslint-disable-next-line no-sequences
      object.events[eventKey].reduceRight((event, l) => (l(event), event), {
        shared: {},
        ...eventProps
      })
    })
  }
  object.events[eventKey] = object.events[eventKey] || []
  object.events[eventKey].push(listener)
  return () => {
    let currentListeners = object.events[eventKey]
    let index = currentListeners.indexOf(listener)
    currentListeners.splice(index, 1)
    if (!currentListeners.length) {
      delete object.events[eventKey]
      object.events[eventKey + REVERT_MUTATION]()
      delete object.events[eventKey + REVERT_MUTATION]
    }
  }
}

let onStart = ($store, listener) =>
  on($store, listener, START, runListeners => {
    let originListen = $store.listen
    $store.listen = arg => {
      if (!$store.lc && !$store.starting) {
        $store.starting = true
        runListeners()
        delete $store.starting
      }
      return originListen(arg)
    }
    return () => {
      $store.listen = originListen
    }
  })

let onStop = ($store, listener) =>
  on($store, listener, STOP, runListeners => {
    let originOff = $store.off
    $store.off = () => {
      runListeners()
      originOff()
    }
    return () => {
      $store.off = originOff
    }
  })

let onSet = ($store, listener) =>
  on($store, listener, SET, runListeners => {
    let originSet = $store.set
    let originSetKey = $store.setKey
    if ($store.setKey) {
      $store.setKey = (changed, changedValue) => {
        let isAborted
        let abort = () => {
          isAborted = true
        }

        runListeners({
          abort,
          changed,
          newValue: { ...$store.value, [changed]: changedValue }
        })
        if (!isAborted) return originSetKey(changed, changedValue)
      }
    }
    $store.set = newValue => {
      let isAborted
      let abort = () => {
        isAborted = true
      }

      runListeners({ abort, newValue })
      if (!isAborted) return originSet(newValue)
    }
    return () => {
      $store.set = originSet
      $store.setKey = originSetKey
    }
  })

let onNotify = ($store, listener) =>
  on($store, listener, NOTIFY, runListeners => {
    let originNotify = $store.notify
    $store.notify = (oldValue, changed) => {
      let isAborted
      let abort = () => {
        isAborted = true
      }

      runListeners({ abort, changed, oldValue })
      if (!isAborted) return originNotify(oldValue, changed)
    }
    return () => {
      $store.notify = originNotify
    }
  })

let STORE_UNMOUNT_DELAY = 1000

let onMount = ($store, initialize) => {
  let listener = payload => {
    let destroy = initialize(payload)
    if (destroy) $store.events[UNMOUNT].push(destroy)
  }
  return on($store, listener, MOUNT, runListeners => {
    let originListen = $store.listen
    $store.listen = (...args) => {
      if (!$store.lc && !$store.active) {
        $store.active = true
        runListeners()
      }
      return originListen(...args)
    }

    let originOff = $store.off
    $store.events[UNMOUNT] = []
    $store.off = () => {
      originOff()
      setTimeout(() => {
        if ($store.active && !$store.lc) {
          $store.active = false
          for (let destroy of $store.events[UNMOUNT]) destroy()
          $store.events[UNMOUNT] = []
        }
      }, STORE_UNMOUNT_DELAY)
    }

    if (true) {
      let originClean = $store[_clean_stores_index_js__WEBPACK_IMPORTED_MODULE_0__.clean]
      $store[_clean_stores_index_js__WEBPACK_IMPORTED_MODULE_0__.clean] = () => {
        for (let destroy of $store.events[UNMOUNT]) destroy()
        $store.events[UNMOUNT] = []
        $store.active = false
        originClean()
      }
    }

    return () => {
      $store.listen = originListen
      $store.off = originOff
    }
  })
}


/***/ }),

/***/ "./node_modules/nanostores/task/index.js":
/*!***********************************************!*\
  !*** ./node_modules/nanostores/task/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   allTasks: () => (/* binding */ allTasks),
/* harmony export */   cleanTasks: () => (/* binding */ cleanTasks),
/* harmony export */   startTask: () => (/* binding */ startTask),
/* harmony export */   task: () => (/* binding */ task)
/* harmony export */ });
let tasks = 0
let resolves = []

function startTask() {
  tasks += 1
  return () => {
    tasks -= 1
    if (tasks === 0) {
      let prevResolves = resolves
      resolves = []
      for (let i of prevResolves) i()
    }
  }
}

function task(cb) {
  let endTask = startTask()
  let promise = cb().finally(endTask)
  promise.t = true
  return promise
}

function allTasks() {
  if (tasks === 0) {
    return Promise.resolve()
  } else {
    return new Promise(resolve => {
      resolves.push(resolve)
    })
  }
}

function cleanTasks() {
  tasks = 0
}


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./src/extension.ts");
/******/ 	module.exports = __webpack_exports__;
/******/ 	
/******/ })()
;
//# sourceMappingURL=extension.js.map