/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// @ts-check
import withDefaults from '../shared.webpack.config.mjs';

export default withDefaults({
    context: import.meta.dirname,
    entry: {
        extension: './src/extension.ts'
    },
    // Use CommonJS output (standard for VS Code extensions)
    // The shared.webpack.config.mjs already sets libraryTarget: 'commonjs'
    externals: {
        'vscode': 'commonjs vscode',
        // ws (WebSocket) library and its optional native dependencies
        // These need to be external because they're Node.js native modules
        'bufferutil': 'commonjs bufferutil',
        'utf-8-validate': 'commonjs utf-8-validate',
    },
    resolve: {
        fallback: {
            'bufferutil': false,
            'utf-8-validate': false,
        }
    },
});