# BlackSwan Web

Web-focused BlackSwan extension for VS Code: HTTP capture/history, scope, request replay, discovery, and vulnerability workflows.

## XSS assistant

Native VS Code UX for XSS testing:

- IntelliSense payload suggestions when editing HTTP request values
- Diagnostics (squiggles + Problems panel) for passive reflection signals
- Code actions to insert payloads or run an active scan on the current request

Settings:

- `blackswan-web.xss.autoScan.enabled` (default: true)
- `blackswan-web.xss.autoScan.inScopeOnly` (default: true)
- `blackswan-web.xss.activeScan.maxParams` (default: 5)
- `blackswan-web.xss.activeScan.maxProbesPerParam` (default: 2)
- `blackswan-web.xss.debug.enabled` (default: false)

## OWASP report

- Add custom categories/tests via commands:
  - `OWASP: Add Category`
  - `OWASP: Add Test`
- Add a request to a test: `OWASP: Add Request to Test`
- Generate AI tests on a criteria via the context menu.
- Debug logging: `blackswan-web.owasp.debug.enabled`

## Authentication

`blackswan-web` does **not** depend on any `blackswan` exported APIs.

When auth is required, it uses VS Code’s built-in authentication API:

- Provider id: `blackswan`
- Calls `vscode.authentication.getSession('blackswan', scopes, { createIfNone: true })`

If no authentication provider is registered (for example, if the core `blackswan` extension isn’t installed), `blackswan-web` will degrade gracefully and prompt you accordingly.

## Migration guide (from legacy `blackswan`)

This split is a **breaking change** for users of the legacy single extension.

### Views

- `blackswan.proxy.history` → `blackswan-web.proxy.history`
- `blackswan.proxy.scope` → `blackswan-web.proxy.scope`
- `blackswan.proxy.requestDetails` → `blackswan-web.proxy.requestDetails`

### Commands

- `blackswan.openWebview` → `blackswan-web.openDashboard`
- `blackswan.openDiscovery` → `blackswan-web.openDiscovery`
- `blackswan.proxy.*` → `blackswan-web.proxy.*`
- `blackswan.jwt.*` → `blackswan-web.jwt.*`

### Settings

- `blackswan.proxy.port` → `blackswan-web.proxy.port`
- `blackswan.proxy.autoStart` → `blackswan-web.proxy.autoStart`
- `blackswan.proxy.scope` → `blackswan-web.proxy.scope`
- `blackswan.proxy.excludeFromScope` → `blackswan-web.proxy.excludeFromScope`
- `blackswan.proxy.maxHistorySize` → `blackswan-web.proxy.maxHistorySize`
- `blackswan.proxy.defaultSortMode` → `blackswan-web.proxy.defaultSortMode`
- `blackswan.environmentVariables` → `blackswan-web.environmentVariables`
- `blackswan.enableSendRequestCodeLens` → `blackswan-web.enableSendRequestCodeLens`

