# DI Migration Tracking

This file tracks the migration of commands from the legacy `ExtensionInstance` pattern to the new `@Command` decorator with dependency injection.

## Migration Status

### Completed ✅

| Command | File | Date |
|---------|------|------|
| StartProxyCommand | `features/history/capture/StartProxyCommand.ts` | 2026-01-22 |
| StopProxyCommand | `features/history/capture/StopProxyCommand.ts` | 2026-01-22 |
| ClearHistoryCommand | `features/history/requests/ClearHistoryCommand.ts` | 2026-01-22 |
| DeleteRequestCommand | `features/history/requests/DeleteRequestCommand.ts` | 2026-01-22 |
| DeleteDomainCommand | `features/history/requests/DeleteDomainCommand.ts` | 2026-01-22 |
| DeletePathCommand | `features/history/requests/DeletePathCommand.ts` | 2026-01-22 |
| ExportRequestsCommand | `features/history/requests/ExportRequestsCommand.ts` | 2026-01-22 |
| LoadDummyRequestsCommand | `features/history/requests/LoadDummyRequestsCommand.ts` | 2026-01-22 |
| SendToRepeaterCommand | `features/history/requests/SendToRepeaterCommand.ts` | 2026-01-22 |
| OpenInEditorCommand | `features/history/requests/OpenInEditorCommand.ts` | 2026-01-22 |
| RevealRequestCommand | `features/history/requests/RevealRequestCommand.ts` | 2026-01-22 |
| CopyAsCurlCommand | `features/history/requests/CopyAsCurlCommand.ts` | 2026-01-22 |
| AddToScopeCommand | `features/history/scope/AddToScopeCommand.ts` | 2026-01-22 |
| AddDomainToScopeCommand | `features/history/scope/AddDomainToScopeCommand.ts` | 2026-01-22 |
| AddPathToScopeCommand | `features/history/scope/AddPathToScopeCommand.ts` | 2026-01-22 |
| RemoveFromScopeCommand | `features/history/scope/RemoveFromScopeCommand.ts` | 2026-01-22 |
| ExcludeDomainFromScopeCommand | `features/history/scope/ExcludeDomainFromScopeCommand.ts` | 2026-01-22 |
| ExcludePathFromScopeCommand | `features/history/scope/ExcludePathFromScopeCommand.ts` | 2026-01-22 |
| ClearScopeCommand | `features/history/scope/ClearScopeCommand.ts` | 2026-01-22 |
| SaveRequestCommand | `features/history/storage/SaveRequestCommand.ts` | 2026-01-22 |
| SaveRequestFromEditorCommand | `features/history/storage/SaveRequestFromEditorCommand.ts` | 2026-01-22 |
| DeleteStoredRequestCommand | `features/history/storage/DeleteStoredRequestCommand.ts` | 2026-01-22 |
| OpenStoredRequestsCommand | `features/history/storage/OpenStoredRequestsCommand.ts` | 2026-01-22 |
| StorageStatsCommand | `features/history/storage/StorageStatsCommand.ts` | 2026-01-22 |
| OpenDashboardCommand | `commands/app/OpenDashboardCommand.ts` | 2026-01-22 |
| OpenDiscoveryCommand | `commands/app/OpenDiscoveryCommand.ts` | 2026-01-22 |
| OpenSettingsCommand | `commands/app/OpenSettingsCommand.ts` | 2026-01-22 |
| SwitchEnvironmentCommand | `commands/app/SwitchEnvironmentCommand.ts` | 2026-01-22 |
| ClearHistoryCommand (Discovery) | `commands/discovery/ClearHistoryCommand.ts` | 2026-01-22 |
| DeleteScanCommand | `commands/discovery/DeleteScanCommand.ts` | 2026-01-22 |
| LoadScanCommand | `commands/discovery/LoadScanCommand.ts` | 2026-01-22 |
| OpenGraphCommand | `commands/discovery/OpenGraphCommand.ts` | 2026-01-22 |
| OpenSubdomainDetailsCommand | `commands/discovery/OpenSubdomainDetailsCommand.ts` | 2026-01-22 |
| StartScanCommand | `commands/discovery/StartScanCommand.ts` | 2026-01-22 |
| StopScanCommand | `commands/discovery/StopScanCommand.ts` | 2026-01-22 |
| RefreshReportCommand | `features/analysis/owasp/RefreshReportCommand.ts` | 2026-01-22 |
| ToggleHideUselessCommand | `features/analysis/owasp/ToggleHideUselessCommand.ts` | 2026-01-22 |
| ClassifyRouteCommand | `features/analysis/owasp/ClassifyRouteCommand.ts` | 2026-01-22 |
| AddCategoryCommand | `features/analysis/owasp/AddCategoryCommand.ts` | 2026-01-22 |
| AddTestCommand | `features/analysis/owasp/AddTestCommand.ts` | 2026-01-22 |
| GenerateTestWithAiCommand | `features/analysis/owasp/GenerateTestWithAiCommand.ts` | 2026-01-22 |
| AddRequestToTestCommand | `features/analysis/owasp/AddRequestToTestCommand.ts` | 2026-01-22 |

### Pending Migration 📋

#### Pwn Manager Commands (`features/pwn/manager/`)

- [ ] MarkRequiredCommand
- [ ] MarkUselessCommand
- [ ] MarkPwnedCommand
- [ ] MarkUnclassifiedCommand

#### Generation Commands

- [ ] GenerateXssCommand (`features/xss/generation/`)
- [ ] SniperXssCommand (`features/xss/generation/`)
- [ ] GenerateJwtCommand (`features/jwt/generation/`)
- [ ] SniperJwtCommand (`features/jwt/generation/`)

#### Analysis Commands (`features/analysis/`)

- [ ] AnalyzeSeverityCommand (`features/analysis/severity/`)
- [ ] AnalyzeCurrentRequestCommand (`features/analysis/vulnerability/`)

#### History Sorting Commands (`features/history/sorting/`)

- [ ] SetSortModeCommand

#### History Views Commands (`features/history/views/`)

- [ ] LoadMoreRequestsCommand

#### History Requests Commands (Legacy - need PwnAttemptStatusUpdater refactor)

- [ ] RepeatRequestCommand (`features/history/requests/`)
- [ ] SendRequestCommand (`features/history/requests/`)

---

## Total Progress: 42/55 commands migrated (76%)
