"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchResultsProvider = exports.SearchResultItem = void 0;
const vscode = __importStar(require("vscode"));
class SearchResultItem extends vscode.TreeItem {
    label;
    collapsibleState;
    searchResult;
    constructor(label, collapsibleState, searchResult) {
        super(label, collapsibleState);
        this.label = label;
        this.collapsibleState = collapsibleState;
        this.searchResult = searchResult;
        if (searchResult) {
            this.contextValue = 'searchResult';
            this.iconPath = this.getResultIcon(searchResult.type);
            this.description = searchResult.value;
            this.tooltip = `${searchResult.path}\n${searchResult.value}`;
            // Command to navigate to result
            this.command = {
                command: 'recaf.goToSearchResult',
                title: 'Go to Result',
                arguments: [searchResult]
            };
        }
        else {
            this.contextValue = 'searchGroup';
            this.iconPath = new vscode.ThemeIcon('search');
        }
    }
    getResultIcon(type) {
        switch (type.toLowerCase()) {
            case 'string':
                return new vscode.ThemeIcon('quote');
            case 'number':
                return new vscode.ThemeIcon('symbol-number');
            case 'reference':
                return new vscode.ThemeIcon('references');
            case 'class':
                return new vscode.ThemeIcon('symbol-class');
            case 'field':
                return new vscode.ThemeIcon('symbol-field');
            case 'method':
                return new vscode.ThemeIcon('symbol-method');
            default:
                return new vscode.ThemeIcon('search');
        }
    }
}
exports.SearchResultItem = SearchResultItem;
class SearchResultsProvider {
    client;
    _onDidChangeTreeData = new vscode.EventEmitter();
    onDidChangeTreeData = this._onDidChangeTreeData.event;
    results = [];
    searchQuery = '';
    searchType = '';
    constructor(client) {
        this.client = client;
    }
    refresh() {
        this._onDidChangeTreeData.fire();
    }
    clear() {
        this.results = [];
        this.searchQuery = '';
        this.searchType = '';
        this._onDidChangeTreeData.fire();
    }
    setResults(results, query, type) {
        this.results = results;
        this.searchQuery = query;
        this.searchType = type;
        this._onDidChangeTreeData.fire();
    }
    getTreeItem(element) {
        return element;
    }
    async getChildren(element) {
        if (!element) {
            // Root level
            if (this.results.length === 0) {
                if (this.searchQuery) {
                    return [
                        new SearchResultItem(`No results for "${this.searchQuery}"`, vscode.TreeItemCollapsibleState.None)
                    ];
                }
                return [
                    new SearchResultItem('Use "Recaf: Search..." commands to find content', vscode.TreeItemCollapsibleState.None)
                ];
            }
            // Group results by class/file
            const groups = new Map();
            for (const result of this.results) {
                const path = result.path.split('/').slice(0, -1).join('/');
                if (!groups.has(path)) {
                    groups.set(path, []);
                }
                groups.get(path).push(result);
            }
            // Create tree items
            const items = [];
            // Show header
            items.push(new SearchResultItem(`${this.results.length} results for "${this.searchQuery}" (${this.searchType})`, vscode.TreeItemCollapsibleState.None));
            // Show results
            for (const result of this.results.slice(0, 100)) { // Limit to 100 results
                items.push(new SearchResultItem(result.path.split('/').pop() || result.path, vscode.TreeItemCollapsibleState.None, result));
            }
            if (this.results.length > 100) {
                items.push(new SearchResultItem(`... and ${this.results.length - 100} more results`, vscode.TreeItemCollapsibleState.None));
            }
            return items;
        }
        return [];
    }
    getParent(element) {
        return null;
    }
    getResults() {
        return this.results;
    }
}
exports.SearchResultsProvider = SearchResultsProvider;
//# sourceMappingURL=SearchResultsProvider.js.map