"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.MappingsTreeProvider = exports.MappingsTreeItem = void 0;
const vscode = __importStar(require("vscode"));
class MappingsTreeItem extends vscode.TreeItem {
    label;
    collapsibleState;
    mappingType;
    count;
    constructor(label, collapsibleState, mappingType, count) {
        super(label, collapsibleState);
        this.label = label;
        this.collapsibleState = collapsibleState;
        this.mappingType = mappingType;
        this.count = count;
        if (mappingType) {
            switch (mappingType) {
                case 'class':
                    this.iconPath = new vscode.ThemeIcon('symbol-class');
                    this.description = `${count} mappings`;
                    break;
                case 'field':
                    this.iconPath = new vscode.ThemeIcon('symbol-field');
                    this.description = `${count} mappings`;
                    break;
                case 'method':
                    this.iconPath = new vscode.ThemeIcon('symbol-method');
                    this.description = `${count} mappings`;
                    break;
            }
            this.contextValue = mappingType;
        }
        else {
            this.iconPath = new vscode.ThemeIcon('references');
            this.contextValue = 'mappings-root';
        }
    }
}
exports.MappingsTreeItem = MappingsTreeItem;
class MappingsTreeProvider {
    client;
    _onDidChangeTreeData = new vscode.EventEmitter();
    onDidChangeTreeData = this._onDidChangeTreeData.event;
    currentMappings = null;
    constructor(client) {
        this.client = client;
    }
    refresh() {
        this.currentMappings = null;
        this._onDidChangeTreeData.fire();
    }
    async loadMappings() {
        try {
            this.currentMappings = await this.client.getCurrentMappings();
            this._onDidChangeTreeData.fire();
        }
        catch (error) {
            console.error('Failed to load mappings:', error);
        }
    }
    getTreeItem(element) {
        return element;
    }
    async getChildren(element) {
        if (!element) {
            // Root level - load current mappings
            if (!this.currentMappings) {
                try {
                    await this.loadMappings();
                }
                catch {
                    return [];
                }
            }
            if (!this.currentMappings) {
                return [
                    new MappingsTreeItem('No mappings loaded', vscode.TreeItemCollapsibleState.None)
                ];
            }
            const totalMappings = this.currentMappings.classCount +
                this.currentMappings.fieldCount +
                this.currentMappings.methodCount;
            if (totalMappings === 0) {
                return [
                    new MappingsTreeItem('No mappings defined', vscode.TreeItemCollapsibleState.None)
                ];
            }
            return [
                new MappingsTreeItem('Classes', vscode.TreeItemCollapsibleState.None, 'class', this.currentMappings.classCount),
                new MappingsTreeItem('Fields', vscode.TreeItemCollapsibleState.None, 'field', this.currentMappings.fieldCount),
                new MappingsTreeItem('Methods', vscode.TreeItemCollapsibleState.None, 'method', this.currentMappings.methodCount)
            ];
        }
        return [];
    }
    getParent(element) {
        return null;
    }
    getMappingInfo() {
        return this.currentMappings;
    }
}
exports.MappingsTreeProvider = MappingsTreeProvider;
//# sourceMappingURL=MappingsTreeProvider.js.map