"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.JarCustomEditorProvider = void 0;
const vscode = __importStar(require("vscode"));
const path = __importStar(require("path"));
/**
 * Custom editor provider for JAR files.
 * When a JAR file is opened, it converts it to a folder view instead of showing binary error.
 */
class JarCustomEditorProvider {
    client;
    openingJars = new Set(); // Track JARs currently being opened
    constructor(client) {
        this.client = client;
    }
    async openCustomDocument(uri, openContext, token) {
        // Return a minimal document - we'll handle the actual opening in resolveCustomEditor
        return {
            uri,
            dispose: () => { }
        };
    }
    async resolveCustomEditor(document, webviewPanel, token) {
        // Set up webview with a simple message
        webviewPanel.webview.options = {
            enableScripts: false
        };
        webviewPanel.webview.html = `<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
	<title>Opening JAR file...</title>
</head>
<body>
	<p>Opening JAR file as folder...</p>
</body>
</html>`;
        // Convert JAR file to folder
        // Ensure we get the file system path, not a URI string
        let jarPath = document.uri.fsPath;
        // If fsPath doesn't work or gives us a URI-like path, try to extract from the URI
        if (!jarPath || jarPath.includes('://') || jarPath.startsWith('//file:')) {
            // Try to extract the actual file path from the URI
            if (document.uri.scheme === 'file') {
                // For file URIs, use the path component directly
                jarPath = document.uri.path;
                // Remove leading slash if present (Unix paths)
                if (jarPath.startsWith('/') && jarPath.length > 1 && jarPath[1] !== '/') {
                    // Keep the leading slash for absolute paths
                }
                else if (jarPath.startsWith('//')) {
                    // Handle //file:///... format
                    jarPath = jarPath.replace(/^\/\/file:\/\/\//, '/');
                    jarPath = jarPath.replace(/^\/\/file:\/\//, '/');
                }
            }
            else {
                // For other schemes, try to extract from path
                jarPath = document.uri.path;
                // Remove URI-like prefixes
                jarPath = jarPath.replace(/^\/\/file:\/\/\//, '/');
                jarPath = jarPath.replace(/^\/\/file:\/\//, '/');
                jarPath = jarPath.replace(/^file:\/\//, '');
            }
        }
        // Clean up any remaining URI artifacts
        jarPath = jarPath.replace(/^\/\/+/, '/'); // Remove multiple leading slashes
        jarPath = jarPath.replace(/^file:\/\//, ''); // Remove file:// prefix if present
        // Ensure it's a valid absolute path
        if (!jarPath || (!path.isAbsolute(jarPath) && !jarPath.startsWith('/'))) {
            vscode.window.showErrorMessage(`Invalid JAR file path: ${jarPath} (original URI: ${document.uri.toString()})`);
            webviewPanel.dispose();
            return;
        }
        // Debug logging
        console.log(`[JarCustomEditor] Opening JAR - URI: ${document.uri.toString()}, fsPath: ${document.uri.fsPath}, extracted path: ${jarPath}`);
        // Prevent duplicate opens
        if (this.openingJars.has(jarPath)) {
            console.log(`[JarCustomEditor] JAR ${jarPath} is already being opened, skipping duplicate request`);
            webviewPanel.dispose();
            return;
        }
        this.openingJars.add(jarPath);
        try {
            // Open JAR in workspace (for server operations)
            // Ensure we're passing a clean file path, not a URI
            await this.client.openJar(jarPath);
            // Create JAR URI - normalize path for cross-platform compatibility
            let normalizedPath = jarPath.replace(/\\/g, '/');
            if (!normalizedPath.startsWith('/')) {
                normalizedPath = '/' + normalizedPath;
            }
            // Handle Windows drive letters (C:\... -> /C:/...)
            if (normalizedPath.match(/^\/[A-Z]:/i)) {
                // Already has leading slash, good
            }
            else if (normalizedPath.match(/^[A-Z]:/i)) {
                normalizedPath = '/' + normalizedPath;
            }
            const jarFolderUri = vscode.Uri.parse(`jar:file://${normalizedPath}`);
            // Check if already added as workspace folder
            const workspaceFolders = vscode.workspace.workspaceFolders || [];
            const alreadyAdded = workspaceFolders.some(folder => folder.uri.toString() === jarFolderUri.toString());
            if (!alreadyAdded) {
                // Add JAR as a workspace folder
                const folderIndex = workspaceFolders.length;
                vscode.workspace.updateWorkspaceFolders(folderIndex, 0, { uri: jarFolderUri, name: path.basename(jarPath) });
            }
            // Close the webview after a short delay to allow the folder to be added
            setTimeout(() => {
                try {
                    webviewPanel.dispose();
                }
                catch (e) {
                    // Already disposed, ignore
                }
                // Remove from opening set after a delay
                setTimeout(() => this.openingJars.delete(jarPath), 1000);
            }, 100);
        }
        catch (error) {
            vscode.window.showErrorMessage(`Failed to open JAR file: ${error}`);
            // Remove from opening set on error
            this.openingJars.delete(jarPath);
            // Close webview on error too
            setTimeout(() => {
                try {
                    webviewPanel.dispose();
                }
                catch (e) {
                    // Already disposed, ignore
                }
            }, 100);
        }
    }
}
exports.JarCustomEditorProvider = JarCustomEditorProvider;
//# sourceMappingURL=JarCustomEditorProvider.js.map