"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileTreeProvider = exports.FileTreeItem = void 0;
const vscode = __importStar(require("vscode"));
class FileTreeItem extends vscode.TreeItem {
    label;
    collapsibleState;
    fileInfo;
    isDirectory;
    constructor(label, collapsibleState, fileInfo, isDirectory = false) {
        super(label, collapsibleState);
        this.label = label;
        this.collapsibleState = collapsibleState;
        this.fileInfo = fileInfo;
        this.isDirectory = isDirectory;
        if (fileInfo) {
            this.contextValue = fileInfo.isDirectory ? 'directory' : 'file';
            this.iconPath = fileInfo.isDirectory
                ? new vscode.ThemeIcon('folder')
                : this.getFileIcon(fileInfo.name);
            this.description = fileInfo.isDirectory ? '' : this.formatSize(fileInfo.size);
            if (!fileInfo.isDirectory) {
                this.command = {
                    command: 'recaf.openFile',
                    title: 'Open File',
                    arguments: [fileInfo.name]
                };
            }
        }
        else if (isDirectory) {
            this.contextValue = 'directory';
            this.iconPath = new vscode.ThemeIcon('folder');
        }
    }
    getFileIcon(name) {
        const ext = name.split('.').pop()?.toLowerCase();
        switch (ext) {
            case 'xml':
                return new vscode.ThemeIcon('file-code');
            case 'json':
                return new vscode.ThemeIcon('json');
            case 'properties':
            case 'yml':
            case 'yaml':
                return new vscode.ThemeIcon('settings-gear');
            case 'txt':
            case 'md':
                return new vscode.ThemeIcon('file-text');
            case 'png':
            case 'jpg':
            case 'jpeg':
            case 'gif':
            case 'ico':
                return new vscode.ThemeIcon('file-media');
            case 'mf':
                return new vscode.ThemeIcon('file-text');
            default:
                return new vscode.ThemeIcon('file');
        }
    }
    formatSize(bytes) {
        if (bytes < 1024)
            return `${bytes} B`;
        if (bytes < 1024 * 1024)
            return `${(bytes / 1024).toFixed(1)} KB`;
        return `${(bytes / (1024 * 1024)).toFixed(1)} MB`;
    }
}
exports.FileTreeItem = FileTreeItem;
class FileTreeProvider {
    client;
    _onDidChangeTreeData = new vscode.EventEmitter();
    onDidChangeTreeData = this._onDidChangeTreeData.event;
    files = [];
    directoryTree = null;
    constructor(client) {
        this.client = client;
    }
    refresh() {
        this.files = [];
        this.directoryTree = null;
        this._onDidChangeTreeData.fire();
    }
    async loadFiles() {
        try {
            this.files = await this.client.getFiles();
            this.directoryTree = this.buildDirectoryTree(this.files);
            this._onDidChangeTreeData.fire();
        }
        catch (error) {
            console.error('Failed to load files:', error);
        }
    }
    buildDirectoryTree(files) {
        const root = {
            name: '',
            files: [],
            children: new Map()
        };
        for (const file of files) {
            const parts = file.name.split('/');
            const fileName = parts.pop();
            let current = root;
            for (const part of parts) {
                if (!current.children.has(part)) {
                    current.children.set(part, {
                        name: part,
                        files: [],
                        children: new Map()
                    });
                }
                current = current.children.get(part);
            }
            current.files.push({ ...file, name: fileName });
        }
        return root;
    }
    getTreeItem(element) {
        return element;
    }
    async getChildren(element) {
        if (!element) {
            // Root level - load files if needed
            if (this.files.length === 0) {
                try {
                    await this.loadFiles();
                }
                catch {
                    return [];
                }
            }
            if (!this.directoryTree) {
                return [];
            }
            return this.getDirectoryChildren(this.directoryTree);
        }
        if (element.contextValue === 'directory') {
            if (!this.directoryTree)
                return [];
            const node = this.findDirectoryNode(this.directoryTree, element.label);
            if (node) {
                return this.getDirectoryChildren(node);
            }
            return [];
        }
        return [];
    }
    getDirectoryChildren(node) {
        const items = [];
        // Add child directories
        for (const [name, child] of node.children) {
            items.push(new FileTreeItem(name, vscode.TreeItemCollapsibleState.Collapsed, undefined, true));
        }
        // Add files
        for (const file of node.files) {
            items.push(new FileTreeItem(file.name, vscode.TreeItemCollapsibleState.None, file));
        }
        return items;
    }
    findDirectoryNode(root, fullPath) {
        const parts = fullPath.split('/').filter(p => p.length > 0);
        let current = root;
        for (const part of parts) {
            if (current.children.has(part)) {
                current = current.children.get(part);
            }
            else {
                return null;
            }
        }
        return current;
    }
    getParent(element) {
        return null;
    }
}
exports.FileTreeProvider = FileTreeProvider;
//# sourceMappingURL=FileTreeProvider.js.map