"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.DecompiledDocumentProvider = void 0;
const vscode = __importStar(require("vscode"));
class DecompiledDocumentProvider {
    client;
    _onDidChange = new vscode.EventEmitter();
    onDidChange = this._onDidChange.event;
    cache = new Map();
    constructor(client) {
        this.client = client;
    }
    async provideTextDocumentContent(uri) {
        // Remove .java extension if present (URI includes it for display, but server expects internal format)
        let className = uri.path;
        if (className.endsWith('.java')) {
            className = className.slice(0, -5); // Remove '.java'
        }
        const decompiler = uri.query || undefined;
        // Check cache first
        const cacheKey = `${className}:${decompiler || 'default'}`;
        if (this.cache.has(cacheKey)) {
            return this.cache.get(cacheKey);
        }
        try {
            const result = await this.client.decompile(className, decompiler);
            if (result.success) {
                // Add header comment
                const header = [
                    `/*`,
                    ` * Decompiled by Recaf using ${result.decompiler}`,
                    ` * Class: ${className}`,
                    ` * Generated: ${new Date().toISOString()}`,
                    ` */`,
                    '',
                    ''
                ].join('\n');
                const content = header + result.source;
                this.cache.set(cacheKey, content);
                return content;
            }
            else {
                return `// Decompilation failed: ${result.error || 'Unknown error'}`;
            }
        }
        catch (error) {
            return `// Error decompiling class: ${error}`;
        }
    }
    invalidate(className) {
        // Remove all cached entries for this class
        for (const key of this.cache.keys()) {
            if (key.startsWith(className + ':')) {
                this.cache.delete(key);
            }
        }
        // Notify VS Code that the content changed
        const uri = vscode.Uri.parse(`recaf:${className}`);
        this._onDidChange.fire(uri);
    }
    clearCache() {
        this.cache.clear();
    }
    /**
     * Create a URI for viewing a decompiled class
     */
    static createUri(className, decompiler) {
        const query = decompiler ? `?${decompiler}` : '';
        return vscode.Uri.parse(`recaf:${className}.java${query}`);
    }
}
exports.DecompiledDocumentProvider = DecompiledDocumentProvider;
//# sourceMappingURL=DecompiledDocumentProvider.js.map