"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerCommands = registerCommands;
const vscode = __importStar(require("vscode"));
const path = __importStar(require("path"));
const ClassTreeProvider_1 = require("../providers/ClassTreeProvider");
const DecompiledDocumentProvider_1 = require("../providers/DecompiledDocumentProvider");
function registerCommands(context, client, providers) {
    // Open JAR as Folder (from context menu)
    context.subscriptions.push(vscode.commands.registerCommand('recaf.openJarAsFolder', async (uri) => {
        let jarUri;
        if (uri) {
            // Called from context menu
            jarUri = uri;
        }
        else {
            // Fallback to file picker
            const fileUri = await vscode.window.showOpenDialog({
                canSelectFiles: true,
                canSelectFolders: false,
                canSelectMany: false,
                filters: {
                    javaArchives: ['jar', 'war', 'ear'],
                    classFiles: ['class'],
                    allFiles: ['*']
                },
                title: 'Open JAR File'
            });
            if (fileUri && fileUri.length > 0) {
                jarUri = fileUri[0];
            }
        }
        if (jarUri) {
            try {
                await vscode.window.withProgress({
                    location: vscode.ProgressLocation.Notification,
                    title: 'Opening JAR file...',
                    cancellable: false
                }, async (progress) => {
                    progress.report({ increment: 0, message: 'Loading JAR file...' });
                    // Open JAR in workspace (for server operations)
                    const jarPath = jarUri.fsPath;
                    const result = await client.openJar(jarPath);
                    if (result) {
                        progress.report({ increment: 50, message: 'Opening as folder...' });
                        // Create JAR URI - normalize path for cross-platform compatibility
                        let normalizedPath = jarPath.replace(/\\/g, '/');
                        if (!normalizedPath.startsWith('/')) {
                            normalizedPath = '/' + normalizedPath;
                        }
                        // Handle Windows drive letters (C:\... -> /C:/...)
                        if (normalizedPath.match(/^\/[A-Z]:/i)) {
                            // Already has leading slash, good
                        }
                        else if (normalizedPath.match(/^[A-Z]:/i)) {
                            normalizedPath = '/' + normalizedPath;
                        }
                        const jarFolderUri = vscode.Uri.parse(`jar:file://${normalizedPath}`);
                        // Add JAR as a workspace folder
                        const workspaceFolders = vscode.workspace.workspaceFolders || [];
                        const folderIndex = workspaceFolders.length;
                        vscode.workspace.updateWorkspaceFolders(folderIndex, 0, { uri: jarFolderUri, name: path.basename(jarPath) });
                        // Also refresh tree views for backward compatibility
                        progress.report({ increment: 75, message: 'Loading classes...' });
                        providers.classTree.refresh();
                        await providers.classTree.loadClasses();
                        providers.fileTree.refresh();
                        await providers.fileTree.loadFiles();
                        providers.decompiledProvider.clearCache();
                        progress.report({ increment: 100, message: 'Done' });
                        vscode.window.showInformationMessage(`Opened: ${result.name || result.primaryResource || 'workspace'}`);
                    }
                    else {
                        vscode.window.showErrorMessage('Failed to open JAR file');
                    }
                });
            }
            catch (error) {
                vscode.window.showErrorMessage(`Error opening JAR: ${error}`);
            }
        }
    }));
    // Open JAR
    context.subscriptions.push(vscode.commands.registerCommand('recaf.openJar', async () => {
        const fileUri = await vscode.window.showOpenDialog({
            canSelectFiles: true,
            canSelectFolders: false,
            canSelectMany: false,
            filters: {
                javaArchives: ['jar', 'war', 'ear'],
                classFiles: ['class'],
                allFiles: ['*']
            },
            title: 'Open JAR File'
        });
        if (fileUri && fileUri.length > 0) {
            try {
                await vscode.window.withProgress({
                    location: vscode.ProgressLocation.Notification,
                    title: 'Opening JAR file...',
                    cancellable: false
                }, async (progress) => {
                    progress.report({ increment: 0, message: 'Loading JAR file...' });
                    // Open JAR in workspace (for server operations)
                    const jarPath = fileUri[0].fsPath;
                    const result = await client.openJar(jarPath);
                    if (result) {
                        progress.report({ increment: 50, message: 'Opening as folder...' });
                        // Create JAR URI - normalize path for cross-platform compatibility
                        let normalizedPath = jarPath.replace(/\\/g, '/');
                        if (!normalizedPath.startsWith('/')) {
                            normalizedPath = '/' + normalizedPath;
                        }
                        // Handle Windows drive letters (C:\... -> /C:/...)
                        if (normalizedPath.match(/^\/[A-Z]:/i)) {
                            // Already has leading slash, good
                        }
                        else if (normalizedPath.match(/^[A-Z]:/i)) {
                            normalizedPath = '/' + normalizedPath;
                        }
                        const jarUri = vscode.Uri.parse(`jar:file://${normalizedPath}`);
                        // Add JAR as a workspace folder
                        const workspaceFolders = vscode.workspace.workspaceFolders || [];
                        const folderIndex = workspaceFolders.length;
                        vscode.workspace.updateWorkspaceFolders(folderIndex, 0, { uri: jarUri, name: path.basename(jarPath) });
                        // Also refresh tree views for backward compatibility
                        progress.report({ increment: 75, message: 'Loading classes...' });
                        providers.classTree.refresh();
                        await providers.classTree.loadClasses();
                        providers.fileTree.refresh();
                        await providers.fileTree.loadFiles();
                        providers.decompiledProvider.clearCache();
                        progress.report({ increment: 100, message: 'Done' });
                        vscode.window.showInformationMessage(`Opened: ${result.name || result.primaryResource || 'workspace'}`);
                    }
                    else {
                        vscode.window.showErrorMessage('Failed to open JAR file');
                    }
                });
            }
            catch (error) {
                vscode.window.showErrorMessage(`Error opening JAR: ${error}`);
            }
        }
    }));
    // Close Workspace
    context.subscriptions.push(vscode.commands.registerCommand('recaf.closeWorkspace', async () => {
        try {
            await client.closeWorkspace();
            providers.classTree.refresh();
            providers.fileTree.refresh();
            providers.mappingsTree.refresh();
            providers.searchResults.clear();
            providers.decompiledProvider.clearCache();
            vscode.window.showInformationMessage('Workspace closed');
        }
        catch (error) {
            vscode.window.showErrorMessage(`Error closing workspace: ${error}`);
        }
    }));
    // Refresh
    context.subscriptions.push(vscode.commands.registerCommand('recaf.refresh', async () => {
        providers.classTree.refresh();
        await providers.classTree.loadClasses();
        providers.fileTree.refresh();
        await providers.fileTree.loadFiles();
        providers.mappingsTree.refresh();
        await providers.mappingsTree.loadMappings();
    }));
    // Decompile Class
    context.subscriptions.push(vscode.commands.registerCommand('recaf.decompileClass', async (classNameOrItem) => {
        let className;
        if (typeof classNameOrItem === 'string') {
            className = classNameOrItem;
        }
        else if (classNameOrItem instanceof ClassTreeProvider_1.ClassTreeItem && classNameOrItem.classInfo) {
            className = classNameOrItem.classInfo.name;
        }
        else {
            // Prompt for class name
            className = await vscode.window.showInputBox({
                prompt: 'Enter class name (internal format)',
                placeHolder: 'com/example/MyClass'
            });
        }
        if (className) {
            const uri = DecompiledDocumentProvider_1.DecompiledDocumentProvider.createUri(className);
            const doc = await vscode.workspace.openTextDocument(uri);
            await vscode.window.showTextDocument(doc, { preview: false });
        }
    }));
    // Search String
    context.subscriptions.push(vscode.commands.registerCommand('recaf.searchString', async () => {
        const query = await vscode.window.showInputBox({
            prompt: 'Enter search string',
            placeHolder: 'Search for text...'
        });
        if (query) {
            const mode = await vscode.window.showQuickPick(['contains', 'exact', 'startsWith', 'endsWith', 'regex'], { placeHolder: 'Select search mode' });
            if (mode) {
                try {
                    await vscode.window.withProgress({
                        location: vscode.ProgressLocation.Notification,
                        title: 'Searching...',
                        cancellable: false
                    }, async () => {
                        const results = await client.searchString(query, mode);
                        providers.searchResults.setResults(results, query, `string:${mode}`);
                    });
                }
                catch (error) {
                    vscode.window.showErrorMessage(`Search failed: ${error}`);
                }
            }
        }
    }));
    // Search Number
    context.subscriptions.push(vscode.commands.registerCommand('recaf.searchNumber', async () => {
        const valueStr = await vscode.window.showInputBox({
            prompt: 'Enter number to search for',
            placeHolder: '42'
        });
        if (valueStr) {
            const value = parseFloat(valueStr);
            if (isNaN(value)) {
                vscode.window.showErrorMessage('Invalid number');
                return;
            }
            try {
                await vscode.window.withProgress({
                    location: vscode.ProgressLocation.Notification,
                    title: 'Searching...',
                    cancellable: false
                }, async () => {
                    const results = await client.searchNumber(value);
                    providers.searchResults.setResults(results, valueStr, 'number');
                });
            }
            catch (error) {
                vscode.window.showErrorMessage(`Search failed: ${error}`);
            }
        }
    }));
    // Search Reference
    context.subscriptions.push(vscode.commands.registerCommand('recaf.searchReference', async () => {
        const owner = await vscode.window.showInputBox({
            prompt: 'Enter class name pattern',
            placeHolder: 'com/example/MyClass'
        });
        if (owner) {
            const name = await vscode.window.showInputBox({
                prompt: 'Enter member name (optional)',
                placeHolder: 'methodName or fieldName'
            });
            try {
                await vscode.window.withProgress({
                    location: vscode.ProgressLocation.Notification,
                    title: 'Searching...',
                    cancellable: false
                }, async () => {
                    let results;
                    if (name) {
                        results = await client.searchMemberReference(owner, name);
                    }
                    else {
                        results = await client.searchClassReference(owner);
                    }
                    providers.searchResults.setResults(results, `${owner}${name ? '.' + name : ''}`, 'reference');
                });
            }
            catch (error) {
                vscode.window.showErrorMessage(`Search failed: ${error}`);
            }
        }
    }));
    // Go to search result
    context.subscriptions.push(vscode.commands.registerCommand('recaf.goToSearchResult', async (result) => {
        // Extract class name from path
        const pathParts = result.path.split('/');
        const classNameMatch = result.path.match(/([^/]+)\.class/);
        if (classNameMatch) {
            const className = result.path.replace('.class', '').replace(/\//g, '/');
            const uri = DecompiledDocumentProvider_1.DecompiledDocumentProvider.createUri(className);
            const doc = await vscode.workspace.openTextDocument(uri);
            await vscode.window.showTextDocument(doc, { preview: false });
        }
    }));
    // Import Mappings
    context.subscriptions.push(vscode.commands.registerCommand('recaf.importMappings', async () => {
        const formats = await client.getMappingFormats();
        const format = await vscode.window.showQuickPick(formats, {
            placeHolder: 'Select mapping format (or leave empty for auto-detect)'
        });
        const fileUri = await vscode.window.showOpenDialog({
            canSelectFiles: true,
            canSelectFolders: false,
            canSelectMany: false,
            filters: {
                'Mapping Files': ['txt', 'map', 'srg', 'csrg', 'tsrg', 'tiny', 'proguard'],
                'All Files': ['*']
            },
            title: 'Import Mappings'
        });
        if (fileUri && fileUri.length > 0) {
            try {
                const result = await client.importMappings(fileUri[0].fsPath, format);
                if (result) {
                    vscode.window.showInformationMessage(`Imported mappings: ${result.classCount} classes, ${result.fieldCount} fields, ${result.methodCount} methods`);
                    providers.mappingsTree.refresh();
                }
            }
            catch (error) {
                vscode.window.showErrorMessage(`Failed to import mappings: ${error}`);
            }
        }
    }));
    // Apply Mappings
    context.subscriptions.push(vscode.commands.registerCommand('recaf.applyMappings', async () => {
        const formats = await client.getMappingFormats();
        const format = await vscode.window.showQuickPick(formats, {
            placeHolder: 'Select mapping format'
        });
        if (!format)
            return;
        const fileUri = await vscode.window.showOpenDialog({
            canSelectFiles: true,
            canSelectFolders: false,
            canSelectMany: false,
            title: 'Select Mapping File'
        });
        if (fileUri && fileUri.length > 0) {
            try {
                await vscode.window.withProgress({
                    location: vscode.ProgressLocation.Notification,
                    title: 'Applying mappings...',
                    cancellable: false
                }, async () => {
                    const count = await client.applyMappings(fileUri[0].fsPath, format);
                    vscode.window.showInformationMessage(`Applied mappings to ${count} classes`);
                    providers.classTree.refresh();
                    await providers.classTree.loadClasses();
                    providers.decompiledProvider.clearCache();
                    providers.mappingsTree.refresh();
                });
            }
            catch (error) {
                vscode.window.showErrorMessage(`Failed to apply mappings: ${error}`);
            }
        }
    }));
    // Export Mappings
    context.subscriptions.push(vscode.commands.registerCommand('recaf.exportMappings', async () => {
        const formats = await client.getMappingFormats();
        const format = await vscode.window.showQuickPick(formats, {
            placeHolder: 'Select mapping format'
        });
        if (!format)
            return;
        const fileUri = await vscode.window.showSaveDialog({
            filters: {
                'Mapping Files': ['txt', 'map', 'srg']
            },
            title: 'Export Mappings'
        });
        if (fileUri) {
            try {
                const success = await client.exportMappings(fileUri.fsPath, format);
                if (success) {
                    vscode.window.showInformationMessage('Mappings exported successfully');
                }
            }
            catch (error) {
                vscode.window.showErrorMessage(`Failed to export mappings: ${error}`);
            }
        }
    }));
    // Rename Class
    context.subscriptions.push(vscode.commands.registerCommand('recaf.renameClass', async (item) => {
        let oldName;
        if (item instanceof ClassTreeProvider_1.ClassTreeItem && item.classInfo) {
            oldName = item.classInfo.name;
        }
        else {
            oldName = await vscode.window.showInputBox({
                prompt: 'Enter current class name',
                placeHolder: 'com/example/OldClass'
            });
        }
        if (!oldName)
            return;
        const newName = await vscode.window.showInputBox({
            prompt: 'Enter new class name',
            value: oldName,
            placeHolder: 'com/example/NewClass'
        });
        if (newName && newName !== oldName) {
            try {
                const success = await client.renameClass(oldName, newName);
                if (success) {
                    vscode.window.showInformationMessage(`Renamed ${oldName} to ${newName}`);
                    providers.classTree.refresh();
                    await providers.classTree.loadClasses();
                    providers.decompiledProvider.invalidate(oldName);
                    providers.mappingsTree.refresh();
                }
            }
            catch (error) {
                vscode.window.showErrorMessage(`Failed to rename class: ${error}`);
            }
        }
    }));
    // Rename Field
    context.subscriptions.push(vscode.commands.registerCommand('recaf.renameField', async () => {
        const ownerName = await vscode.window.showInputBox({
            prompt: 'Enter owner class name',
            placeHolder: 'com/example/MyClass'
        });
        if (!ownerName)
            return;
        const fieldName = await vscode.window.showInputBox({
            prompt: 'Enter current field name'
        });
        if (!fieldName)
            return;
        const fieldDesc = await vscode.window.showInputBox({
            prompt: 'Enter field descriptor',
            placeHolder: 'Ljava/lang/String;'
        });
        if (!fieldDesc)
            return;
        const newName = await vscode.window.showInputBox({
            prompt: 'Enter new field name'
        });
        if (newName && newName !== fieldName) {
            try {
                const success = await client.renameField(ownerName, fieldName, fieldDesc, newName);
                if (success) {
                    vscode.window.showInformationMessage(`Renamed field to ${newName}`);
                    providers.decompiledProvider.invalidate(ownerName);
                    providers.mappingsTree.refresh();
                }
            }
            catch (error) {
                vscode.window.showErrorMessage(`Failed to rename field: ${error}`);
            }
        }
    }));
    // Rename Method
    context.subscriptions.push(vscode.commands.registerCommand('recaf.renameMethod', async () => {
        const ownerName = await vscode.window.showInputBox({
            prompt: 'Enter owner class name',
            placeHolder: 'com/example/MyClass'
        });
        if (!ownerName)
            return;
        const methodName = await vscode.window.showInputBox({
            prompt: 'Enter current method name'
        });
        if (!methodName)
            return;
        const methodDesc = await vscode.window.showInputBox({
            prompt: 'Enter method descriptor',
            placeHolder: '(Ljava/lang/String;)V'
        });
        if (!methodDesc)
            return;
        const newName = await vscode.window.showInputBox({
            prompt: 'Enter new method name'
        });
        if (newName && newName !== methodName) {
            try {
                const success = await client.renameMethod(ownerName, methodName, methodDesc, newName);
                if (success) {
                    vscode.window.showInformationMessage(`Renamed method to ${newName}`);
                    providers.decompiledProvider.invalidate(ownerName);
                    providers.mappingsTree.refresh();
                }
            }
            catch (error) {
                vscode.window.showErrorMessage(`Failed to rename method: ${error}`);
            }
        }
    }));
    // Recompile
    context.subscriptions.push(vscode.commands.registerCommand('recaf.recompile', async () => {
        const editor = vscode.window.activeTextEditor;
        if (!editor) {
            vscode.window.showErrorMessage('No active editor');
            return;
        }
        const document = editor.document;
        if (!document.uri.scheme.startsWith('recaf')) {
            vscode.window.showErrorMessage('This is not a decompiled class');
            return;
        }
        const className = document.uri.path.replace('.java', '');
        const source = document.getText();
        try {
            await vscode.window.withProgress({
                location: vscode.ProgressLocation.Notification,
                title: 'Recompiling...',
                cancellable: false
            }, async () => {
                const result = await client.recompile(className, source);
                if (result.success) {
                    vscode.window.showInformationMessage(`Recompiled ${result.classesAffected} class(es)`);
                    providers.decompiledProvider.invalidate(className);
                }
                else {
                    vscode.window.showErrorMessage(`Compilation failed: ${result.error}`);
                }
            });
        }
        catch (error) {
            vscode.window.showErrorMessage(`Recompilation failed: ${error}`);
        }
    }));
    // Disassemble
    context.subscriptions.push(vscode.commands.registerCommand('recaf.disassemble', async (item) => {
        let className;
        if (item instanceof ClassTreeProvider_1.ClassTreeItem && item.classInfo) {
            className = item.classInfo.name;
        }
        else {
            className = await vscode.window.showInputBox({
                prompt: 'Enter class name',
                placeHolder: 'com/example/MyClass'
            });
        }
        if (className) {
            try {
                const source = await client.disassemble(className);
                // Open in new untitled document with JASM language
                const doc = await vscode.workspace.openTextDocument({
                    language: 'jasm',
                    content: source
                });
                await vscode.window.showTextDocument(doc);
            }
            catch (error) {
                vscode.window.showErrorMessage(`Disassembly failed: ${error}`);
            }
        }
    }));
    // Assemble
    context.subscriptions.push(vscode.commands.registerCommand('recaf.assemble', async () => {
        const editor = vscode.window.activeTextEditor;
        if (!editor) {
            vscode.window.showErrorMessage('No active editor');
            return;
        }
        const document = editor.document;
        if (document.languageId !== 'jasm') {
            vscode.window.showWarningMessage('This does not appear to be a JASM file');
        }
        const className = await vscode.window.showInputBox({
            prompt: 'Enter target class name',
            placeHolder: 'com/example/MyClass'
        });
        if (className) {
            const source = document.getText();
            try {
                await vscode.window.withProgress({
                    location: vscode.ProgressLocation.Notification,
                    title: 'Assembling...',
                    cancellable: false
                }, async () => {
                    const result = await client.assemble(className, source);
                    if (result.success) {
                        vscode.window.showInformationMessage('Assembly successful');
                        providers.classTree.refresh();
                        providers.decompiledProvider.invalidate(className);
                    }
                    else {
                        vscode.window.showErrorMessage(`Assembly failed: ${result.error}`);
                    }
                });
            }
            catch (error) {
                vscode.window.showErrorMessage(`Assembly failed: ${error}`);
            }
        }
    }));
    // Export JAR
    context.subscriptions.push(vscode.commands.registerCommand('recaf.exportJar', async () => {
        const fileUri = await vscode.window.showSaveDialog({
            filters: {
                'Java Archives': ['jar']
            },
            title: 'Export JAR'
        });
        if (fileUri) {
            try {
                await vscode.window.withProgress({
                    location: vscode.ProgressLocation.Notification,
                    title: 'Exporting JAR...',
                    cancellable: false
                }, async () => {
                    const success = await client.exportJar(fileUri.fsPath);
                    if (success) {
                        vscode.window.showInformationMessage('JAR exported successfully');
                    }
                    else {
                        vscode.window.showErrorMessage('Failed to export JAR');
                    }
                });
            }
            catch (error) {
                vscode.window.showErrorMessage(`Export failed: ${error}`);
            }
        }
    }));
    // Run Script
    context.subscriptions.push(vscode.commands.registerCommand('recaf.runScript', async () => {
        const editor = vscode.window.activeTextEditor;
        if (!editor) {
            // List available scripts
            const scripts = await client.listScripts();
            if (scripts.length === 0) {
                vscode.window.showInformationMessage('No scripts available. Open a script file to run.');
                return;
            }
            const selection = await vscode.window.showQuickPick(scripts.map(s => ({
                label: s.name,
                description: s.description,
                detail: s.filePath,
                script: s
            })), { placeHolder: 'Select a script to run' });
            if (selection) {
                try {
                    const result = await client.runScriptFile(selection.script.fileName);
                    if (result.success) {
                        vscode.window.showInformationMessage('Script executed successfully');
                    }
                    else {
                        vscode.window.showErrorMessage(`Script error: ${result.error}`);
                    }
                }
                catch (error) {
                    vscode.window.showErrorMessage(`Script execution failed: ${error}`);
                }
            }
            return;
        }
        // Run the current editor content as a script
        const source = editor.document.getText();
        try {
            await vscode.window.withProgress({
                location: vscode.ProgressLocation.Notification,
                title: 'Running script...',
                cancellable: false
            }, async () => {
                const result = await client.runScript(source);
                if (result.success) {
                    vscode.window.showInformationMessage('Script executed successfully');
                }
                else {
                    vscode.window.showErrorMessage(`Script error: ${result.error}`);
                    if (result.stackTrace) {
                        const outputChannel = vscode.window.createOutputChannel('Recaf Script');
                        outputChannel.appendLine(result.stackTrace);
                        outputChannel.show();
                    }
                }
            });
        }
        catch (error) {
            vscode.window.showErrorMessage(`Script execution failed: ${error}`);
        }
    }));
    // Type Hierarchy
    context.subscriptions.push(vscode.commands.registerCommand('recaf.typeHierarchy', async (item) => {
        let className;
        if (item instanceof ClassTreeProvider_1.ClassTreeItem && item.classInfo) {
            className = item.classInfo.name;
        }
        else {
            className = await vscode.window.showInputBox({
                prompt: 'Enter class name',
                placeHolder: 'com/example/MyClass'
            });
        }
        if (className) {
            try {
                const [superTypes, subTypes] = await Promise.all([
                    client.getSuperTypes(className),
                    client.getSubTypes(className)
                ]);
                const panel = vscode.window.createWebviewPanel('recafTypeHierarchy', `Type Hierarchy: ${className.split('/').pop()}`, vscode.ViewColumn.Beside, {});
                panel.webview.html = getTypeHierarchyHtml(className, superTypes, subTypes);
            }
            catch (error) {
                vscode.window.showErrorMessage(`Failed to get type hierarchy: ${error}`);
            }
        }
    }));
    // Call Graph
    context.subscriptions.push(vscode.commands.registerCommand('recaf.callGraph', async () => {
        const owner = await vscode.window.showInputBox({
            prompt: 'Enter class name',
            placeHolder: 'com/example/MyClass'
        });
        if (!owner)
            return;
        const name = await vscode.window.showInputBox({
            prompt: 'Enter method name'
        });
        if (!name)
            return;
        const desc = await vscode.window.showInputBox({
            prompt: 'Enter method descriptor',
            placeHolder: '(Ljava/lang/String;)V'
        });
        if (!desc)
            return;
        try {
            const [callers, callees] = await Promise.all([
                client.getCallers(owner, name, desc),
                client.getCallees(owner, name, desc)
            ]);
            const panel = vscode.window.createWebviewPanel('recafCallGraph', `Call Graph: ${name}`, vscode.ViewColumn.Beside, {});
            panel.webview.html = getCallGraphHtml(owner, name, desc, callers, callees);
        }
        catch (error) {
            vscode.window.showErrorMessage(`Failed to get call graph: ${error}`);
        }
    }));
}
function getTypeHierarchyHtml(className, superTypes, subTypes) {
    const formatClass = (name) => name.replace(/\//g, '.');
    return `<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: var(--vscode-font-family); padding: 20px; }
        h2 { color: var(--vscode-foreground); }
        .class-name { font-weight: bold; color: var(--vscode-textLink-foreground); }
        ul { list-style-type: none; padding-left: 20px; }
        li { padding: 4px 0; }
        .current { background: var(--vscode-editor-selectionBackground); padding: 4px 8px; border-radius: 4px; }
        .section { margin: 20px 0; }
    </style>
</head>
<body>
    <div class="section">
        <h2>Super Types</h2>
        <ul>
            ${superTypes.map(t => `<li class="class-name">${formatClass(t)}</li>`).join('')}
        </ul>
    </div>

    <div class="section">
        <h2>Current Class</h2>
        <div class="current class-name">${formatClass(className)}</div>
    </div>

    <div class="section">
        <h2>Sub Types</h2>
        <ul>
            ${subTypes.length > 0
        ? subTypes.map(t => `<li class="class-name">${formatClass(t)}</li>`).join('')
        : '<li>(none)</li>'}
        </ul>
    </div>
</body>
</html>`;
}
function getCallGraphHtml(owner, name, desc, callers, callees) {
    const formatMethod = (ref) => `${ref.owner.replace(/\//g, '.')}.${ref.name}${ref.desc}`;
    return `<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: var(--vscode-font-family); padding: 20px; }
        h2 { color: var(--vscode-foreground); }
        .method-name { font-family: monospace; color: var(--vscode-textLink-foreground); }
        ul { list-style-type: none; padding-left: 20px; }
        li { padding: 4px 0; }
        .current { background: var(--vscode-editor-selectionBackground); padding: 4px 8px; border-radius: 4px; }
        .section { margin: 20px 0; }
    </style>
</head>
<body>
    <div class="section">
        <h2>Callers (${callers.length})</h2>
        <ul>
            ${callers.length > 0
        ? callers.map(c => `<li class="method-name">${formatMethod(c)}</li>`).join('')
        : '<li>(none)</li>'}
        </ul>
    </div>

    <div class="section">
        <h2>Current Method</h2>
        <div class="current method-name">${owner.replace(/\//g, '.')}.${name}${desc}</div>
    </div>

    <div class="section">
        <h2>Callees (${callees.length})</h2>
        <ul>
            ${callees.length > 0
        ? callees.map(c => `<li class="method-name">${formatMethod(c)}</li>`).join('')
        : '<li>(none)</li>'}
        </ul>
    </div>
</body>
</html>`;
}
//# sourceMappingURL=index.js.map